/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.security.UserService;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.service.system.InstanceService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.craftercms.studio.model.AuthenticatedUser;
import org.craftercms.studio.model.Site;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class UserServiceImpl
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    private UserServiceInternal userServiceInternal;
    private ConfigurationService configurationService;
    private GroupServiceInternal groupServiceInternal;
    private SiteService siteService;
    private EntitlementValidator entitlementValidator;
    private GeneralLockService generalLockService;
    private SecurityService securityService;
    private StudioConfiguration studioConfiguration;
    private AuditServiceInternal auditServiceInternal;
    private ObjectFactory<FreeMarkerConfig> freeMarkerConfig;
    private JavaMailSender emailService;
    private JavaMailSender emailServiceNoAuth;
    private InstanceService instanceService;
    private TextEncryptor encryptor;

    public UserServiceImpl(UserServiceInternal userServiceInternal, ConfigurationService configurationService, GroupServiceInternal groupServiceInternal, SiteService siteService, EntitlementValidator entitlementValidator, GeneralLockService generalLockService, SecurityService securityService, StudioConfiguration studioConfiguration, AuditServiceInternal auditServiceInternal, ObjectFactory<FreeMarkerConfig> freeMarkerConfig, JavaMailSender emailService, JavaMailSender emailServiceNoAuth, InstanceService instanceService, TextEncryptor encryptor) {
        this.userServiceInternal = userServiceInternal;
        this.configurationService = configurationService;
        this.groupServiceInternal = groupServiceInternal;
        this.siteService = siteService;
        this.entitlementValidator = entitlementValidator;
        this.generalLockService = generalLockService;
        this.securityService = securityService;
        this.studioConfiguration = studioConfiguration;
        this.auditServiceInternal = auditServiceInternal;
        this.freeMarkerConfig = freeMarkerConfig;
        this.emailService = emailService;
        this.emailServiceNoAuth = emailServiceNoAuth;
        this.instanceService = instanceService;
        this.encryptor = encryptor;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public List<User> getAllUsersForSite(long orgId, String siteId, int offset, int limit, String sort) throws ServiceLayerException {
        List<String> groupNames = this.groupServiceInternal.getSiteGroups(siteId);
        return this.userServiceInternal.getAllUsersForSite(orgId, groupNames, offset, limit, sort);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public List<User> getAllUsers(int offset, int limit, String sort) throws ServiceLayerException {
        return this.userServiceInternal.getAllUsers(offset, limit, sort);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public int getAllUsersForSiteTotal(long orgId, String siteId) throws ServiceLayerException {
        return this.userServiceInternal.getAllUsersForSiteTotal(orgId, siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public int getAllUsersTotal() throws ServiceLayerException {
        return this.userServiceInternal.getAllUsersTotal();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="create_users")
    public User createUser(User user) throws UserAlreadyExistsException, ServiceLayerException, AuthenticationException {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.USER, 1);
        }
        catch (EntitlementException e) {
            throw new ServiceLayerException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Exception)((Object)e));
        }
        User toRet = this.userServiceInternal.createUser(user);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("CREATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(user.getUsername());
        auditLog.setPrimaryTargetType("User");
        auditLog.setPrimaryTargetValue(user.getUsername());
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="update_users")
    public void updateUser(User user) throws ServiceLayerException, UserNotFoundException, AuthenticationException {
        this.userServiceInternal.updateUser(user);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("UPDATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(user.getUsername());
        auditLog.setPrimaryTargetType("User");
        auditLog.setPrimaryTargetValue(user.getUsername());
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_users")
    public void deleteUsers(List<Long> userIds, List<String> usernames) throws ServiceLayerException, AuthenticationException, UserNotFoundException {
        AuthenticatedUser currentUser = this.getCurrentUser();
        if (CollectionUtils.containsAny(userIds, Arrays.asList(currentUser.getId())) || CollectionUtils.containsAny(usernames, Arrays.asList(currentUser.getUsername()))) {
            throw new ServiceLayerException("Cannot delete self.");
        }
        this.generalLockService.lock("remove_system_admin_member_lock");
        try {
            try {
                Group g = this.groupServiceInternal.getGroupByName("system_admin");
                List<User> members = this.groupServiceInternal.getGroupMembers(g.getId(), 0, Integer.MAX_VALUE, "");
                if (CollectionUtils.isNotEmpty(members)) {
                    ArrayList<User> membersAfterRemove = new ArrayList<User>();
                    membersAfterRemove.addAll(members);
                    members.forEach(m -> {
                        if (CollectionUtils.isNotEmpty((Collection)userIds) && userIds.contains(m.getId())) {
                            membersAfterRemove.remove(m);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)usernames) && usernames.contains(m.getUsername())) {
                            membersAfterRemove.remove(m);
                        }
                    });
                    if (CollectionUtils.isEmpty(membersAfterRemove)) {
                        throw new ServiceLayerException("Removing all members of the System Admin group is not allowed. We must have at least one system administrator.");
                    }
                }
            }
            catch (GroupNotFoundException e) {
                throw new ServiceLayerException("The System Admin group is not found.", e);
            }
            List<User> toDelete = this.userServiceInternal.getUsersByIdOrUsername(userIds, usernames);
            this.userServiceInternal.deleteUsers(userIds, usernames);
            SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("DELETE");
            auditLog.setActorId(this.getCurrentUser().getUsername());
            auditLog.setPrimaryTargetId(siteFeed.getSiteId());
            auditLog.setPrimaryTargetType("User");
            auditLog.setPrimaryTargetValue(siteFeed.getName());
            ArrayList<AuditLogParameter> paramters = new ArrayList<AuditLogParameter>();
            for (User deletedUser : toDelete) {
                AuditLogParameter paramter = new AuditLogParameter();
                paramter.setTargetId(Long.toString(deletedUser.getId()));
                paramter.setTargetType("User");
                paramter.setTargetValue(deletedUser.getUsername());
                paramters.add(paramter);
            }
            auditLog.setParameters(paramters);
            this.auditServiceInternal.insertAuditLog(auditLog);
        }
        finally {
            this.generalLockService.unlock("remove_system_admin_member_lock");
        }
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public User getUserByIdOrUsername(long userId, String username) throws ServiceLayerException, UserNotFoundException {
        return this.userServiceInternal.getUserByIdOrUsername(userId, username);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="update_users")
    public List<User> enableUsers(List<Long> userIds, List<String> usernames, boolean enabled) throws ServiceLayerException, UserNotFoundException, AuthenticationException {
        List<User> users = this.userServiceInternal.enableUsers(userIds, usernames, enabled);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setSiteId(siteFeed.getId());
        if (enabled) {
            auditLog.setOperation("ENABLE");
        } else {
            auditLog.setOperation("DISABLE");
        }
        auditLog.setActorId(this.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(siteFeed.getSiteId());
        auditLog.setPrimaryTargetType("User");
        auditLog.setPrimaryTargetValue(siteFeed.getName());
        ArrayList<AuditLogParameter> paramters = new ArrayList<AuditLogParameter>();
        for (User u : users) {
            AuditLogParameter paramter = new AuditLogParameter();
            paramter.setTargetId(Long.toString(u.getId()));
            paramter.setTargetType("User");
            paramter.setTargetValue(u.getUsername());
            paramters.add(paramter);
        }
        auditLog.setParameters(paramters);
        this.auditServiceInternal.insertAuditLog(auditLog);
        return users;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public List<Site> getUserSites(long userId, String username) throws ServiceLayerException, UserNotFoundException {
        ArrayList<Site> sites = new ArrayList<Site>();
        Set<String> allSites = this.siteService.getAllAvailableSites();
        List<Group> userGroups = this.userServiceInternal.getUserGroups(userId, username);
        boolean isSysAdmin = userGroups.stream().anyMatch(group -> group.getGroupName().equals("system_admin"));
        for (String siteId : allSites) {
            List<String> siteGroups = this.groupServiceInternal.getSiteGroups(siteId);
            if (!isSysAdmin && !userGroups.stream().anyMatch(userGroup -> siteGroups.contains(userGroup.getGroupName()))) continue;
            try {
                SiteFeed siteFeed = this.siteService.getSite(siteId);
                Site site = new Site();
                site.setSiteId(siteFeed.getSiteId());
                site.setDesc(siteFeed.getDescription());
                sites.add(site);
            }
            catch (SiteNotFoundException e) {
                logger.error("Site not found: {0}", e, siteId);
            }
        }
        return sites;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_users")
    public List<String> getUserSiteRoles(long userId, String username, String site) throws ServiceLayerException, UserNotFoundException {
        List<Group> groups = this.userServiceInternal.getUserGroups(userId, username);
        if (CollectionUtils.isNotEmpty(groups)) {
            Map<String, List<String>> roleMappings = this.configurationService.geRoleMappings(site);
            LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
            if (MapUtils.isNotEmpty(roleMappings)) {
                for (Group group : groups) {
                    String groupName = group.getGroupName();
                    if (groupName.equals("system_admin")) {
                        Collection<List<String>> roleSets = roleMappings.values();
                        for (List<String> roleSet : roleSets) {
                            userRoles.addAll(roleSet);
                        }
                        break;
                    }
                    List<String> roles = roleMappings.get(groupName);
                    if (!CollectionUtils.isNotEmpty(roles)) continue;
                    userRoles.addAll(roles);
                }
            }
            return new ArrayList<String>(userRoles);
        }
        return Collections.emptyList();
    }

    @Override
    public AuthenticatedUser getCurrentUser() throws AuthenticationException, ServiceLayerException {
        Authentication authentication = this.securityService.getAuthentication();
        if (authentication != null) {
            User user;
            String username = authentication.getUsername();
            try {
                user = this.userServiceInternal.getUserByIdOrUsername(0L, username);
            }
            catch (UserNotFoundException e) {
                throw new ServiceLayerException("Current authenticated user '" + username + "' wasn't found in repository", e);
            }
            if (user != null) {
                AuthenticatedUser authUser = new AuthenticatedUser(user);
                authUser.setAuthenticationType(authentication.getAuthenticationType());
                return authUser;
            }
            throw new ServiceLayerException("Current authenticated user '" + username + "' wasn't found in repository");
        }
        throw new AuthenticationException("User should be authenticated");
    }

    @Override
    public List<Site> getCurrentUserSites() throws AuthenticationException, ServiceLayerException {
        Authentication authentication = this.securityService.getAuthentication();
        if (authentication != null) {
            try {
                return this.getUserSites(-1L, authentication.getUsername());
            }
            catch (UserNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new AuthenticationException("User should be authenticated");
    }

    @Override
    public List<String> getCurrentUserSiteRoles(String site) throws AuthenticationException, ServiceLayerException {
        Authentication authentication = this.securityService.getAuthentication();
        if (authentication != null) {
            try {
                return this.getUserSiteRoles(-1L, authentication.getUsername(), site);
            }
            catch (UserNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new AuthenticationException("User should be authenticated");
    }

    @Override
    public String getCurrentUserSsoLogoutUrl() throws AuthenticationException, ServiceLayerException {
        Authentication authentication = this.securityService.getAuthentication();
        if (authentication != null) {
            return authentication.getSsoLogoutUrl();
        }
        throw new AuthenticationException("User should be authenticated");
    }

    @Override
    public boolean forgotPassword(String username) throws ServiceLayerException, UserNotFoundException, UserExternallyManagedException {
        logger.debug("Getting user profile for " + username, new Object[0]);
        User user = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
        boolean success = false;
        if (user == null) {
            logger.info("User profile not found for " + username, new Object[0]);
            throw new UserNotFoundException();
        }
        if (user.isExternallyManaged()) {
            throw new UserExternallyManagedException();
        }
        if (user.getEmail() == null) {
            logger.info("User " + username + " does not have assigned email with account", new Object[0]);
            throw new ServiceLayerException("User " + username + " does not have assigned email with account");
        }
        String email = user.getEmail();
        logger.debug("Creating security token for forgot password", new Object[0]);
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime ttl = now.plusMinutes(Long.parseLong(this.studioConfiguration.getProperty("studio.security.forgotPassword.token.timeout")));
        long timestamp = ttl.toInstant().toEpochMilli();
        String studioId = this.instanceService.getInstanceId();
        String token = username + "|" + studioId + "|" + timestamp;
        String hashedToken = this.encryptToken(token);
        logger.debug("Sending forgot password email to " + email, new Object[0]);
        this.sendForgotPasswordEmail(email, hashedToken);
        success = true;
        return success;
    }

    private String encryptToken(String token) {
        try {
            String hashedToken = this.encryptor.encrypt(token);
            return Base64.getEncoder().encodeToString(hashedToken.getBytes(StandardCharsets.UTF_8));
        }
        catch (CryptoException e) {
            logger.error("Error while encrypting forgot password token", (Exception)((Object)e), new Object[0]);
            return null;
        }
    }

    private String decryptToken(String hashedToken) {
        try {
            byte[] hashedTokenBytes = Base64.getDecoder().decode(hashedToken.getBytes(StandardCharsets.UTF_8));
            return this.encryptor.decrypt(new String(hashedTokenBytes, StandardCharsets.UTF_8));
        }
        catch (CryptoException e) {
            logger.error("Error while decrypting forgot password token", (Exception)((Object)e), new Object[0]);
            return null;
        }
    }

    private void sendForgotPasswordEmail(String emailAddress, String token) {
        try {
            Template emailTemplate = ((FreeMarkerConfig)this.freeMarkerConfig.getObject()).getConfiguration().getTemplate(this.studioConfiguration.getProperty("studio.security.forgotPassword.email.template"));
            StringWriter out = new StringWriter();
            HashMap<String, String> model = new HashMap<String, String>();
            RequestContext context = RequestContext.getCurrent();
            HttpServletRequest request = context.getRequest();
            String authoringUrl = request.getRequestURL().toString().replace(request.getPathInfo(), "");
            String serviceUrl = this.studioConfiguration.getProperty("studio.security.resetPassword.serviceUrl");
            model.put("authoringUrl", authoringUrl);
            model.put("serviceUrl", serviceUrl);
            model.put("token", token);
            if (emailTemplate != null) {
                emailTemplate.process(model, (Writer)out);
            }
            MimeMessage mimeMessage = this.emailService.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
            messageHelper.setFrom(this.studioConfiguration.getProperty("studio.mail.from.default"));
            messageHelper.setTo(emailAddress);
            messageHelper.setSubject(this.studioConfiguration.getProperty("studio.security.forgotPassword.message.subject"));
            messageHelper.setText(((Object)out).toString(), true);
            logger.info("Sending password recovery message to " + emailAddress, new Object[0]);
            if (this.isAuthenticatedSMTP()) {
                this.emailService.send(mimeMessage);
            } else {
                this.emailServiceNoAuth.send(mimeMessage);
            }
            logger.info("Password recovery message successfully sent to " + emailAddress, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Failed to send password recovery message to " + emailAddress, e, new Object[0]);
        }
    }

    @Override
    public User changePassword(String username, String current, String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException, ServiceLayerException, AuthenticationException, UserNotFoundException {
        AuthenticatedUser currentUser = this.getCurrentUser();
        if (currentUser != null && StringUtils.equals((CharSequence)username, (CharSequence)currentUser.getUsername())) {
            boolean success = this.userServiceInternal.changePassword(username, current, newPassword);
            if (success) {
                return this.userServiceInternal.getUserByIdOrUsername(-1L, username);
            }
            throw new ServiceLayerException("Failed to change password");
        }
        throw new PermissionException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public User setPassword(String token, String newPassword) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        boolean success;
        if (!this.validateToken(token)) return null;
        String username = this.getUsernameFromToken(token);
        if (!StringUtils.isNotEmpty((CharSequence)username)) throw new UserNotFoundException("User not found");
        User user = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
        if (user == null) throw new UserNotFoundException("User not found");
        if (!user.isEnabled() || !(success = this.userServiceInternal.setUserPassword(username, newPassword))) return null;
        return user;
    }

    @Override
    public boolean validateToken(String token) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        StringTokenizer tokenElements;
        boolean toRet = false;
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            String username = tokenElements.nextToken();
            User userProfile = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
            if (userProfile == null) {
                logger.info("User profile not found for " + username, new Object[0]);
                throw new UserNotFoundException();
            }
            if (userProfile.isExternallyManaged()) {
                throw new UserExternallyManagedException();
            }
            String studioId = tokenElements.nextToken();
            if (StringUtils.equals((CharSequence)studioId, (CharSequence)this.instanceService.getInstanceId())) {
                ZonedDateTime now;
                long tokenTimestamp = Long.parseLong(tokenElements.nextToken());
                toRet = tokenTimestamp >= (now = ZonedDateTime.now()).toInstant().toEpochMilli();
            }
        }
        return toRet;
    }

    private String getUsernameFromToken(String token) {
        StringTokenizer tokenElements;
        String toRet = "";
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            toRet = tokenElements.nextToken();
        }
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="update_users")
    public boolean resetPassword(String username, String newPassword) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        return this.userServiceInternal.setUserPassword(username, newPassword);
    }

    private boolean isAuthenticatedSMTP() {
        return Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.mail.smtp.auth"));
    }
}

