/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security.internal;

import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.service.security.internal.EncryptionServiceInternal;

public class EncryptionServiceInternalImpl
implements EncryptionServiceInternal {
    protected long delay;
    protected int maxLength;
    protected TextEncryptor textEncryptor;

    public EncryptionServiceInternalImpl(long delay, int maxLength, TextEncryptor textEncryptor) {
        this.delay = delay;
        this.maxLength = maxLength;
        this.textEncryptor = textEncryptor;
    }

    @Override
    public String encrypt(String text) throws ServiceLayerException {
        if (StringUtils.isEmpty((String)text) || text.length() > this.maxLength) {
            throw new InvalidParametersException("The provided text is invalid");
        }
        try {
            Thread.sleep(this.delay * 1000L);
            return this.textEncryptor.encrypt(text);
        }
        catch (InterruptedException | CryptoException e) {
            throw new ServiceLayerException("Error encrypting text", (Exception)e);
        }
    }
}

