/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.GroupDAO;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.exception.configuration.ConfigurationException;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;

public class GroupServiceInternalImpl
implements GroupServiceInternal {
    private GroupDAO groupDao;
    private UserServiceInternal userServiceInternal;
    private ConfigurationService configurationService;

    @Override
    public Group getGroup(long groupId) throws GroupNotFoundException, ServiceLayerException {
        Group group;
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("groupId", groupId);
        try {
            group = this.groupDao.getGroup(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
        if (group != null) {
            return group;
        }
        throw new GroupNotFoundException("No group found for id '" + groupId + "'");
    }

    @Override
    public List<Group> getGroups(List<Long> groupIds) throws GroupNotFoundException, ServiceLayerException {
        List<Group> groups;
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("groupIds", groupIds);
        try {
            groups = this.groupDao.getGroups(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
        if (groups != null) {
            return groups;
        }
        throw new GroupNotFoundException("No group found for id '" + groupIds + "'");
    }

    @Override
    public Group getGroupByName(String groupName) throws GroupNotFoundException, ServiceLayerException {
        Group group;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupName", groupName);
        try {
            group = this.groupDao.getGroupByName(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
        if (group != null) {
            return group;
        }
        throw new GroupNotFoundException("No group found for name '" + groupName + "'");
    }

    @Override
    public boolean groupExists(long groupId, String groupName) throws ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupId", groupId);
        params.put("groupName", groupName);
        try {
            Integer result = this.groupDao.groupExists(params);
            return result > 0;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<Group> getAllGroups(long orgId, int offset, int limit, String sort) throws ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort", sort);
        try {
            return this.groupDao.getAllGroupsForOrganization(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public int getAllGroupsTotal(long orgId) throws ServiceLayerException {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", orgId);
        try {
            return this.groupDao.getAllGroupsForOrganizationTotal(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public Group createGroup(long orgId, String groupName, String groupDescription) throws GroupAlreadyExistsException, ServiceLayerException {
        if (this.groupExists(-1L, groupName)) {
            throw new GroupAlreadyExistsException("Group '" + groupName + "' already exists");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("groupName", groupName);
        params.put("groupDescription", groupDescription);
        try {
            this.groupDao.createGroup(params);
            Group group = new Group();
            group.setId((Long)params.get("id"));
            group.setGroupName(groupName);
            group.setGroupDescription(groupDescription);
            return group;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public Group updateGroup(long orgId, Group group) throws GroupNotFoundException, ServiceLayerException {
        if (!this.groupExists(group.getId(), "")) {
            throw new GroupNotFoundException("No group found for id '" + group.getId() + "'");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", group.getId());
        params.put("orgId", orgId);
        params.put("groupName", group.getGroupName());
        params.put("groupDescription", group.getGroupDescription());
        try {
            this.groupDao.updateGroup(params);
            return group;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public void deleteGroup(List<Long> groupIds) throws GroupNotFoundException, ServiceLayerException {
        for (Long groupId : groupIds) {
            if (this.groupExists(groupId, "")) continue;
            throw new GroupNotFoundException("No group found for id '" + groupId + "'");
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("groupIds", groupIds);
        try {
            this.groupDao.deleteGroups(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<User> getGroupMembers(long groupId, int offset, int limit, String sort) throws GroupNotFoundException, ServiceLayerException {
        if (!this.groupExists(groupId, "")) {
            throw new GroupNotFoundException("No group found for id '" + groupId + "'");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupId", groupId);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort", sort);
        try {
            return this.groupDao.getGroupMembers(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public int getGroupMembersTotal(long groupId) throws GroupNotFoundException, ServiceLayerException {
        if (!this.groupExists(groupId, "")) {
            throw new GroupNotFoundException("No group found for id '" + groupId + "'");
        }
        try {
            return this.groupDao.getGroupMembersTotal(Collections.singletonMap("groupId", groupId));
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<User> addGroupMembers(long groupId, List<Long> userIds, List<String> usernames) throws GroupNotFoundException, UserNotFoundException, ServiceLayerException {
        if (!this.groupExists(groupId, "")) {
            throw new GroupNotFoundException("No group found for id '" + groupId + "'");
        }
        List<User> users = this.userServiceInternal.getUsersByIdOrUsername(userIds, usernames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", users.stream().map(User::getId).collect(Collectors.toList()));
        params.put("groupId", groupId);
        try {
            this.groupDao.addGroupMembers(params);
            return users;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public void removeGroupMembers(long groupId, List<Long> userIds, List<String> usernames) throws GroupNotFoundException, UserNotFoundException, ServiceLayerException {
        if (!this.groupExists(groupId, "")) {
            throw new GroupNotFoundException("No group found for id '" + groupId + "'");
        }
        List<User> users = this.userServiceInternal.getUsersByIdOrUsername(userIds, usernames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", users.stream().map(User::getId).collect(Collectors.toList()));
        params.put("groupId", groupId);
        try {
            this.groupDao.removeGroupMembers(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<String> getSiteGroups(String siteId) throws ServiceLayerException {
        Map<String, List<String>> groupRoleMapping;
        try {
            groupRoleMapping = this.configurationService.geRoleMappings(siteId);
        }
        catch (ConfigurationException e) {
            throw new ServiceLayerException("Unable to get role mappings config for site '" + siteId + "'", e);
        }
        ArrayList<String> groups = new ArrayList<String>();
        groups.addAll(groupRoleMapping.keySet());
        return groups;
    }

    public GroupDAO getGroupDao() {
        return this.groupDao;
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

