/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.craftercms.commons.crypto.CryptoUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserDAO;
import org.craftercms.studio.api.v2.exception.PasswordRequirementsFailedException;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class UserServiceInternalImpl
implements UserServiceInternal {
    private UserDAO userDao;
    private GroupServiceInternal groupServiceInternal;
    private StudioConfiguration studioConfiguration;

    @Override
    public User getUserByIdOrUsername(long userId, String username) throws ServiceLayerException, UserNotFoundException {
        User user;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("username", username);
        try {
            user = this.userDao.getUserByIdOrUsername(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
        if (user == null) {
            throw new UserNotFoundException("No user found for username '" + username + "' or id '" + userId + "'");
        }
        return user;
    }

    @Override
    public List<User> getUsersByIdOrUsername(List<Long> userIds, List<String> usernames) throws ServiceLayerException, UserNotFoundException {
        LinkedList<User> users = new LinkedList<User>();
        Iterator<Object> iterator = userIds.iterator();
        while (iterator.hasNext()) {
            long userId = iterator.next();
            users.add(this.getUserByIdOrUsername(userId, ""));
        }
        for (String username : usernames) {
            Optional<User> user = users.stream().filter(u -> u.getUsername().equals(username)).findFirst();
            if (user.isPresent()) continue;
            users.add(this.getUserByIdOrUsername(-1L, username));
        }
        return users;
    }

    @Override
    public List<User> getAllUsersForSite(long orgId, List<String> groupNames, int offset, int limit, String sort) throws ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupNames", groupNames);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort", "");
        try {
            return this.userDao.getAllUsersForSite(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<User> getAllUsers(int offset, int limit, String sort) throws ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort", sort);
        try {
            return this.userDao.getAllUsers(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public int getAllUsersForSiteTotal(long orgId, String siteId) throws ServiceLayerException {
        List<String> groupNames = this.groupServiceInternal.getSiteGroups(siteId);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("groupNames", groupNames);
        try {
            return this.userDao.getAllUsersForSiteTotal(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public int getAllUsersTotal() throws ServiceLayerException {
        try {
            return this.userDao.getAllUsersTotal();
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public User createUser(User user) throws UserAlreadyExistsException, ServiceLayerException {
        if (this.userExists(-1L, user.getUsername())) {
            throw new UserAlreadyExistsException("User '" + user.getUsername() + "' already exists");
        }
        if (user.isExternallyManaged() || this.verifyPasswordRequirements(user.getPassword())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("username", user.getUsername());
            params.put("password", CryptoUtils.hashPassword((String)user.getPassword()));
            params.put("firstName", user.getFirstName());
            params.put("lastName", user.getLastName());
            params.put("email", user.getEmail());
            params.put("externallyManaged", user.getExternallyManagedAsInt());
            params.put("timezone", "");
            params.put("locale", "");
            params.put("enabled", user.getEnabledAsInt());
            try {
                this.userDao.createUser(params);
                user.setId((Long)params.get("id"));
                return user;
            }
            catch (Exception e) {
                throw new ServiceLayerException("Unknown database error", e);
            }
        }
        throw new PasswordRequirementsFailedException();
    }

    @Override
    public boolean userExists(long userId, String username) throws ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("username", username);
        try {
            Integer result = this.userDao.userExists(params);
            return result > 0;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public void updateUser(User user) throws UserNotFoundException, ServiceLayerException {
        long userId = user.getId();
        String username = user.getUsername() != null ? user.getUsername() : "";
        User oldUser = this.getUserByIdOrUsername(userId, username);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", oldUser.getId());
        params.put("firstName", user.getFirstName());
        params.put("lastName", user.getLastName());
        params.put("email", user.getEmail());
        params.put("timezone", "");
        params.put("locale", "");
        try {
            this.userDao.updateUser(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public void deleteUsers(List<Long> userIds, List<String> usernames) throws UserNotFoundException, ServiceLayerException {
        List<User> users = this.getUsersByIdOrUsername(userIds, usernames);
        HashMap params = new HashMap();
        params.put("userIds", users.stream().map(User::getId).collect(Collectors.toList()));
        try {
            this.userDao.deleteUsers(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public List<User> enableUsers(List<Long> userIds, List<String> usernames, boolean enabled) throws ServiceLayerException, UserNotFoundException {
        List<User> users = this.getUsersByIdOrUsername(userIds, usernames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", users.stream().map(User::getId).collect(Collectors.toList()));
        params.put("enabled", enabled ? 1 : 0);
        try {
            this.userDao.enableUsers(params);
            return this.getUsersByIdOrUsername(userIds, usernames);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public List<Group> getUserGroups(long userId, String username) throws UserNotFoundException, ServiceLayerException {
        if (!this.userExists(userId, username)) {
            throw new UserNotFoundException("No user found for username '" + username + "' or id '" + userId + "'");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("username", username);
        try {
            return this.userDao.getUserGroups(params);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    public boolean isUserMemberOfGroup(String username, String groupName) throws UserNotFoundException, ServiceLayerException {
        if (!this.userExists(-1L, username)) {
            throw new UserNotFoundException("No user found for username '" + username + "'");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupName", groupName);
        params.put("username", username);
        try {
            int result = this.userDao.isUserMemberOfGroup(params);
            return result > 0;
        }
        catch (Exception e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public boolean changePassword(String username, String current, String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException, ServiceLayerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", -1);
        params.put("username", username);
        try {
            User user = this.userDao.getUserByIdOrUsername(params);
            if (user.isExternallyManaged()) {
                throw new UserExternallyManagedException();
            }
            if (CryptoUtils.matchPassword((String)user.getPassword(), (String)current)) {
                if (this.verifyPasswordRequirements(newPassword)) {
                    String hashedPassword = CryptoUtils.hashPassword((String)newPassword);
                    params = new HashMap();
                    params.put("username", username);
                    params.put("password", hashedPassword);
                    this.userDao.setUserPassword(params);
                    return true;
                }
                throw new PasswordRequirementsFailedException();
            }
            throw new PasswordDoesNotMatchException();
        }
        catch (RuntimeException e) {
            throw new ServiceLayerException("Unknown database error", e);
        }
    }

    @Override
    @RetryingOperation
    public boolean setUserPassword(String username, String newPassword) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        if (!this.userExists(-1L, username)) {
            throw new UserNotFoundException();
        }
        if (this.verifyPasswordRequirements(newPassword)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userId", -1);
            params.put("username", username);
            try {
                User user = this.userDao.getUserByIdOrUsername(params);
                if (user.isExternallyManaged()) {
                    throw new UserExternallyManagedException();
                }
                String hashedPassword = CryptoUtils.hashPassword((String)newPassword);
                params = new HashMap();
                params.put("username", username);
                params.put("password", hashedPassword);
                this.userDao.setUserPassword(params);
                return true;
            }
            catch (Exception e) {
                throw new ServiceLayerException("Unknown database error", e);
            }
        }
        throw new PasswordRequirementsFailedException("User password does not fulfill requirements");
    }

    private boolean verifyPasswordRequirements(String password) {
        Pattern pattern = Pattern.compile(this.getPasswordRequirementValidationRegex());
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }

    private String getPasswordRequirementValidationRegex() {
        return this.studioConfiguration.getProperty("studio.security.passwordRequirements.validationRegex");
    }

    @Override
    public User getUserByGitName(String gitName) {
        return this.userDao.getUserByGitName(gitName);
    }

    public UserDAO getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDAO userDao) {
        this.userDao = userDao;
    }

    public GroupServiceInternal getGroupServiceInternal() {
        return this.groupServiceInternal;
    }

    public void setGroupServiceInternal(GroupServiceInternal groupServiceInternal) {
        this.groupServiceInternal = groupServiceInternal;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

