/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.site.internal;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.plugin.PluginDescriptorReader;
import org.craftercms.commons.plugin.exception.PluginException;
import org.craftercms.commons.plugin.model.Parameter;
import org.craftercms.commons.plugin.model.Plugin;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v2.dal.PublishStatus;
import org.craftercms.studio.api.v2.exception.MissingPluginParameterException;
import org.craftercms.studio.api.v2.service.site.internal.SitesServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.factory.annotation.Required;

public class SitesServiceInternalImpl
implements SitesServiceInternal {
    private static final Logger logger = LoggerFactory.getLogger(SitesServiceInternalImpl.class);
    private PluginDescriptorReader descriptorReader;
    private ContentRepository contentRepository;
    private StudioConfiguration studioConfiguration;
    private SiteFeedMapper siteFeedMapper;

    @Override
    public List<PluginDescriptor> getAvailableBlueprints() {
        RepositoryItem[] blueprintsFolders = this.getBlueprintsFolders();
        ArrayList<PluginDescriptor> toRet = new ArrayList<PluginDescriptor>();
        for (RepositoryItem folder : blueprintsFolders) {
            PluginDescriptor descriptor;
            if (!folder.isFolder || (descriptor = this.loadDescriptor(folder)) == null) continue;
            toRet.add(descriptor);
        }
        return toRet;
    }

    @Override
    public PluginDescriptor getBlueprintDescriptor(String id) {
        RepositoryItem[] blueprintsFolders;
        for (RepositoryItem folder : blueprintsFolders = this.getBlueprintsFolders()) {
            PluginDescriptor descriptor;
            if (!folder.isFolder || (descriptor = this.loadDescriptor(folder)) == null || !descriptor.getPlugin().getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public String getBlueprintLocation(String blueprintId) {
        RepositoryItem[] blueprintsFolders;
        for (RepositoryItem folder : blueprintsFolders = this.getBlueprintsFolders()) {
            if (!folder.isFolder) continue;
            Path descriptorPath = this.getBlueprintPath(folder);
            PluginDescriptor descriptor = this.loadDescriptor(folder);
            if (descriptor == null || !descriptor.getPlugin().getId().equals(blueprintId)) continue;
            return descriptorPath.getParent().toAbsolutePath().toString();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PluginDescriptor getSiteBlueprintDescriptor(String id) {
        String descriptorPath = this.studioConfiguration.getProperty("studio.repo.blueprints.descriptor.filename");
        if (!this.contentRepository.contentExists(id, descriptorPath)) return null;
        try (InputStream is = this.contentRepository.getContent(id, descriptorPath);){
            PluginDescriptor pluginDescriptor = this.loadDescriptor(is);
            return pluginDescriptor;
        }
        catch (Exception e) {
            logger.error("Error while getting blueprint descriptor for site " + id, e, new Object[0]);
        }
        return null;
    }

    @Override
    public void validateBlueprintParameters(PluginDescriptor descriptor, Map<String, String> params) throws MissingPluginParameterException {
        Plugin plugin = descriptor.getPlugin();
        if (CollectionUtils.isEmpty((Collection)plugin.getParameters())) {
            logger.debug("There are no parameters defined for blueprint: {0}", plugin.getId());
            return;
        }
        for (Parameter param : plugin.getParameters()) {
            logger.debug("Checking parameter {0} for blueprint {1}", param.getName(), plugin.getId());
            if (param.isRequired()) {
                if (params.containsKey(param.getName()) && !StringUtils.isEmpty((CharSequence)params.get(param.getName()))) continue;
                throw new MissingPluginParameterException(descriptor, param);
            }
            params.putIfAbsent(param.getName(), param.getDefaultValue());
        }
        logger.debug("All required parameters are present for blueprint: {0}", plugin.getId());
    }

    protected RepositoryItem[] getBlueprintsFolders() {
        return this.contentRepository.getContentChildren("", this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
    }

    protected Path getBlueprintPath(RepositoryItem folder) {
        return Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath"), folder.path, folder.name, this.studioConfiguration.getProperty("studio.repo.blueprints.descriptor.filename")).toAbsolutePath();
    }

    protected PluginDescriptor loadDescriptor(InputStream is) {
        try {
            return this.descriptorReader.read(is);
        }
        catch (PluginException e) {
            logger.error("Error while getting descriptor from stream", (Exception)((Object)e), new Object[0]);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PluginDescriptor loadDescriptor(RepositoryItem folder) {
        Path descriptorPath = this.getBlueprintPath(folder);
        if (!Files.exists(descriptorPath, new LinkOption[0])) return null;
        try (FileReader reader = new FileReader(descriptorPath.toString());){
            PluginDescriptor pluginDescriptor = this.descriptorReader.read((Reader)reader);
            return pluginDescriptor;
        }
        catch (IOException | PluginException e) {
            logger.error("Error while getting descriptor for blueprint " + folder.name, (Exception)e, new Object[0]);
        }
        return null;
    }

    @Override
    public PublishStatus getPublishingStatus(String siteId) {
        int ttl = this.studioConfiguration.getProperty("studio.publishing.siteLock.ttl", Integer.class);
        return this.siteFeedMapper.getPublishingStatus(siteId, ttl);
    }

    @Override
    public void clearPublishingLock(String siteId) {
        this.siteFeedMapper.clearPublishingLockForSite(siteId);
    }

    @Required
    public void setDescriptorReader(PluginDescriptorReader descriptorReader) {
        this.descriptorReader = descriptorReader;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SiteFeedMapper getSiteFeedMapper() {
        return this.siteFeedMapper;
    }

    public void setSiteFeedMapper(SiteFeedMapper siteFeedMapper) {
        this.siteFeedMapper = siteFeedMapper;
    }
}

