/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.service.system.ToolsService;
import org.craftercms.studio.model.rest.system.ShellCommandResponse;

public class ToolsServiceImpl
implements ToolsService {
    private static final String CRAFTER_HOME = "CRAFTER_HOME";
    private static final Logger logger = LoggerFactory.getLogger(ToolsServiceImpl.class);
    private DataSource dataSource;
    private UserServiceInternal userServiceInternal;
    private SecurityService securityService;

    public ToolsServiceImpl(DataSource dataSource, UserServiceInternal userServiceInternal, SecurityService securityService) {
        this.dataSource = dataSource;
        this.userServiceInternal = userServiceInternal;
        this.securityService = securityService;
    }

    private boolean isAllowedAccess() throws ServiceLayerException, UserNotFoundException {
        String currentUser = this.securityService.getCurrentUser();
        return this.userServiceInternal.isUserMemberOfGroup(currentUser, "system_admin");
    }

    @Override
    public List<Map<String, Object>> executeDbQuery(String query) throws SQLException, ServiceLayerException, UserNotFoundException {
        if (!this.isAllowedAccess()) {
            throw new AccessDeniedException("Current user not allowed to execute system tools");
        }
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dataSource.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            ResultSetMetaData rsmd = resultSet.getMetaData();
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    row.put(rsmd.getColumnLabel(i + 1), resultSet.getObject(i + 1));
                }
                toRet.add(row);
            }
        }
        return toRet;
    }

    @Override
    public ShellCommandResponse executeShellCommand(String workingDirectory, String command, List<String> arguments) throws IOException, InterruptedException, ServiceLayerException, UserNotFoundException {
        if (!this.isAllowedAccess()) {
            throw new AccessDeniedException("Current user not allowed to execute system tools");
        }
        ArrayList<String> pbParams = new ArrayList<String>();
        pbParams.add(command);
        if (CollectionUtils.isNotEmpty(arguments)) {
            pbParams.addAll(arguments);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(pbParams);
        Map<String, String> environmentVariables = processBuilder.environment();
        String crafterHome = environmentVariables.get(CRAFTER_HOME);
        File crafterHomeFile = new File(crafterHome);
        if (StringUtils.isEmpty((CharSequence)workingDirectory)) {
            processBuilder.directory(crafterHomeFile);
        } else {
            File wd = new File(workingDirectory);
            if (!wd.getCanonicalPath().startsWith(crafterHomeFile.getCanonicalPath() + File.separator)) {
                throw new ServiceLayerException("Not allowed to execute commands outside of crafter home");
            }
            processBuilder.directory(wd);
        }
        String result = "";
        Process process = processBuilder.start();
        ShellCommandResponse scr = new ShellCommandResponse();
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<String> error = new ArrayList<String>();
        BufferedReader dataReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        dataReader.lines().iterator().forEachRemaining(data::add);
        errorReader.lines().iterator().forEachRemaining(error::add);
        process.waitFor();
        process.destroy();
        scr.setData(data);
        scr.setError(error);
        return scr;
    }
}

