/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.ui;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.service.ui.UiService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.ui.internal.UiServiceInternal;
import org.craftercms.studio.model.ui.MenuItem;
import org.springframework.beans.factory.annotation.Required;

public class UiServiceImpl
implements UiService {
    private SecurityService securityService;
    private UiServiceInternal uiServiceInternal;
    private StudioConfiguration studioConfiguration;

    @Required
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Required
    public void setUiServiceInternal(UiServiceInternal uiServiceInternal) {
        this.uiServiceInternal = uiServiceInternal;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Override
    public List<MenuItem> getGlobalMenu() throws AuthenticationException, ServiceLayerException {
        String user = this.securityService.getCurrentUser();
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            Set<String> permissions = this.securityService.getUserPermissions("", "/", user, null);
            return this.uiServiceInternal.getGlobalMenu(permissions);
        }
        throw new AuthenticationException("User is not authenticated");
    }

    @Override
    public String getActiveEnvironment() throws AuthenticationException {
        String user = this.securityService.getCurrentUser();
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            return this.studioConfiguration.getProperty("studio.configuration.environment.active");
        }
        throw new AuthenticationException("User is not authenticated");
    }
}

