/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.ui.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v2.exception.configuration.ConfigurationException;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ConfigUtils;
import org.craftercms.studio.impl.v2.service.ui.internal.UiServiceInternal;
import org.craftercms.studio.model.ui.MenuItem;
import org.springframework.beans.factory.annotation.Required;

public class UiServiceInternalImpl
implements UiServiceInternal {
    private static final String MENU_ITEMS_CONFIG_KEY = "items.item";
    private static final String PERMISSION_CONFIG_KEY = "permission";
    private static final String ID_CONFIG_KEY = "id";
    private static final String LABEL_CONFIG_KEY = "label";
    private static final String ICON_CONFIG_KEY = "icon";
    private static final String ANY_PERMISSION_WILDCARD = "*";
    private StudioConfiguration studioConfiguration;
    private ContentService contentService;

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public List<MenuItem> getGlobalMenu(Set<String> permissions) throws ServiceLayerException {
        if (CollectionUtils.isNotEmpty(permissions)) {
            HierarchicalConfiguration menuConfig = this.getGlobalMenuConfig();
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            List itemsConfig = menuConfig.configurationsAt(MENU_ITEMS_CONFIG_KEY);
            if (CollectionUtils.isNotEmpty((Collection)itemsConfig)) {
                for (HierarchicalConfiguration itemConfig : itemsConfig) {
                    String requiredPermission = this.getRequiredStringProperty((Configuration)itemConfig, PERMISSION_CONFIG_KEY);
                    if (!requiredPermission.equals(ANY_PERMISSION_WILDCARD) && !permissions.contains(requiredPermission)) continue;
                    MenuItem item = new MenuItem();
                    item.setId(this.getRequiredStringProperty((Configuration)itemConfig, ID_CONFIG_KEY));
                    item.setLabel(this.getRequiredStringProperty((Configuration)itemConfig, LABEL_CONFIG_KEY));
                    item.setIcon(this.getRequiredStringProperty((Configuration)itemConfig, ICON_CONFIG_KEY));
                    menuItems.add(item);
                }
            } else {
                throw new ConfigurationException("No menu items found in global menu config");
            }
            return menuItems;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HierarchicalConfiguration getGlobalMenuConfig() throws ConfigurationException {
        String configPath = this.getGlobalMenuConfigPath();
        try (InputStream is = this.contentService.getContent("", configPath);){
            HierarchicalConfiguration<ImmutableNode> hierarchicalConfiguration = ConfigUtils.readXmlConfiguration(is);
            return hierarchicalConfiguration;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to read global menu config @ " + configPath, e);
        }
    }

    protected String getRequiredStringProperty(Configuration config, String key) throws ConfigurationException {
        String property = config.getString(key);
        if (StringUtils.isEmpty((CharSequence)property)) {
            throw new ConfigurationException("Missing required property '" + key + "'");
        }
        return property;
    }

    protected String getGlobalMenuConfigPath() {
        return UrlUtils.concat((String)this.getGlobalConfigPath(), (String)this.getGlobalMenuFileName());
    }

    protected String getGlobalConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.global.configBasePath");
    }

    protected String getGlobalMenuFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.global.menuFileName");
    }
}

