/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.profiles.webdav.WebDavProfile;
import org.craftercms.commons.file.stores.WebDavUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.WebDavException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.webdav.WebDavItem;
import org.craftercms.studio.api.v2.service.webdav.WebDavService;
import org.craftercms.studio.impl.v1.util.config.profiles.SiteAwareConfigProfileLoader;
import org.springframework.util.MimeType;
import org.springframework.web.util.UriUtils;

public class WebDavServiceImpl
implements WebDavService {
    private static final Logger logger = LoggerFactory.getLogger(WebDavServiceImpl.class);
    public static final String FILTER_ALL_ITEMS = "item";
    protected String urlPattern;
    protected SiteAwareConfigProfileLoader<WebDavProfile> profileLoader;
    protected Charset charset = Charset.defaultCharset();

    public WebDavServiceImpl(String urlPattern, SiteAwareConfigProfileLoader<WebDavProfile> profileLoader) {
        this.urlPattern = urlPattern;
        this.profileLoader = profileLoader;
    }

    protected WebDavProfile getProfile(String site, String profileId) throws WebDavException {
        try {
            return this.profileLoader.loadProfile(site, profileId);
        }
        catch (ConfigurationException e) {
            throw new WebDavException("Unable to load WebDav profile", (Exception)((Object)e));
        }
    }

    @Override
    @ValidateParams
    @HasPermission(type=DefaultPermission.class, action="webdav_read")
    public List<WebDavItem> list(@ValidateStringParam(name="siteId") @ProtectedResourceId(value="siteId") String siteId, @ValidateStringParam(name="profileId") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="type") String type) throws WebDavException {
        WebDavProfile profile = this.getProfile(siteId, profileId);
        String listPath = StringUtils.appendIfMissing((String)profile.getBaseUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        try {
            Sardine sardine = WebDavUtils.createClient((WebDavProfile)profile);
            MimeType filterType = StringUtils.isEmpty((CharSequence)type) || type.equals(FILTER_ALL_ITEMS) ? MimeType.valueOf((String)"*/*") : new MimeType(type);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                String[] tokens;
                for (String token : tokens = StringUtils.split((String)path, (String)"/")) {
                    if (!StringUtils.isNotEmpty((CharSequence)token)) continue;
                    listPath = listPath + StringUtils.appendIfMissing((String)UriUtils.encode((String)token, (String)this.charset.name()), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                }
            }
            if (!sardine.exists(listPath)) {
                logger.debug("Folder {0} doesn't exist", listPath);
                return Collections.emptyList();
            }
            logger.debug("Listing resources at {0}", listPath);
            List resources = sardine.list(listPath, 1, true);
            logger.debug("Found {0} resources at {0}", resources.size(), listPath);
            return resources.stream().skip(1L).filter(r -> r.isDirectory() || filterType.includes(MimeType.valueOf((String)r.getContentType()))).map(r -> new WebDavItem(this.getName((DavResource)r), this.getUrl((DavResource)r, profileId, profile), r.isDirectory())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new WebDavException("Error listing resources", e);
        }
    }

    protected String getUrl(DavResource resource, String profileId, WebDavProfile profile) {
        String relativePath = StringUtils.removeFirst((String)resource.getPath(), (String)URI.create(profile.getBaseUrl()).getPath());
        if (resource.isDirectory()) {
            return relativePath;
        }
        return this.getRemoteAssetUrl(profileId, relativePath);
    }

    protected String getRemoteAssetUrl(String profileId, String fullPath) {
        return String.format(this.urlPattern, profileId, StringUtils.removeStart((String)fullPath, (String)"/"));
    }

    protected String getRemoteAssetUrl(String profileId, String path, String filename) {
        String fullPath = UrlUtils.concat((String)path, (String)filename);
        return this.getRemoteAssetUrl(profileId, fullPath);
    }

    protected String getName(DavResource resource) {
        if (StringUtils.isNotEmpty((CharSequence)resource.getDisplayName())) {
            return resource.getDisplayName();
        }
        String path = resource.getPath();
        if (resource.isDirectory()) {
            path = StringUtils.removeEnd((String)path, (String)"/");
        }
        return StringUtils.substringAfterLast((String)path, (String)"/");
    }

    @Override
    @ValidateParams
    @HasPermission(type=DefaultPermission.class, action="webdav_write")
    public WebDavItem upload(@ValidateStringParam(name="siteId") @ProtectedResourceId(value="siteId") String siteId, @ValidateStringParam(name="profileId") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="filename") String filename, InputStream content) throws WebDavException {
        WebDavProfile profile = this.getProfile(siteId, profileId);
        String uploadUrl = StringUtils.appendIfMissing((String)profile.getBaseUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        try {
            Sardine sardine = WebDavUtils.createClient((WebDavProfile)profile);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                String[] folders;
                for (String folder : folders = StringUtils.split((String)path, (String)"/")) {
                    uploadUrl = uploadUrl + StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                    logger.debug("Checking folder {0}", uploadUrl);
                    if (!sardine.exists(uploadUrl)) {
                        logger.debug("Creating folder {0}", uploadUrl);
                        sardine.createDirectory(uploadUrl);
                        logger.debug("Folder {0} created", uploadUrl);
                        continue;
                    }
                    logger.debug("Folder {0} already exists", uploadUrl);
                }
            }
            uploadUrl = StringUtils.appendIfMissing((String)uploadUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            String fileUrl = uploadUrl + UriUtils.encode((String)filename, (String)this.charset.name());
            logger.debug("Starting upload of file {0}", filename);
            logger.debug("Uploading file to {0}", fileUrl);
            sardine.put(fileUrl, content);
            logger.debug("Upload complete for file {0}", fileUrl);
            return new WebDavItem(filename, this.getRemoteAssetUrl(profileId, path, filename), false);
        }
        catch (Exception e) {
            throw new WebDavException("Error uploading file", e);
        }
    }
}

