/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade;

import java.io.InputStream;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.craftercms.commons.config.YamlConfiguration;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.validator.DbIntegrityValidator;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.upgrade.UpgradeManager;
import org.craftercms.studio.api.v2.upgrade.UpgradePipeline;
import org.craftercms.studio.api.v2.upgrade.UpgradePipelineFactory;
import org.craftercms.studio.api.v2.upgrade.VersionProvider;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DefaultUpgradeManagerImpl
implements UpgradeManager,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradeManagerImpl.class);
    private static final ThreadLocal<String> currentFile = new InheritableThreadLocal<String>();
    public static final String SQL_QUERY_SITES_3_0_0 = "select site_id from cstudio_site where system = 0";
    public static final String SQL_QUERY_SITES = "select site_id from site where system = 0";
    public static final String CONFIG_PIPELINE_SUFFIX = ".pipeline";
    protected String siteVersionFilePath;
    protected VersionProvider dbVersionProvider;
    protected UpgradePipelineFactory dbPipelineFactory;
    protected UpgradePipelineFactory bpPipelineFactory;
    protected Resource configurationFile;
    protected DataSource dataSource;
    protected ApplicationContext appContext;
    protected DbIntegrityValidator integrityValidator;
    protected ContentRepository contentRepository;
    protected StudioConfiguration studioConfiguration;

    public static String getCurrentFile() {
        return currentFile.get();
    }

    @Override
    public void upgradeDatabaseAndConfiguration() throws UpgradeException {
        logger.info("Checking upgrades for the database and configuration", new Object[0]);
        UpgradePipeline pipeline = this.dbPipelineFactory.getPipeline(this.dbVersionProvider);
        pipeline.execute();
    }

    protected VersionProvider getVersionProvider(String name, Object ... args) {
        return (VersionProvider)this.appContext.getBean(name, args);
    }

    protected UpgradePipeline getPipeline(VersionProvider versionProvider, String factoryName, Object ... args) throws UpgradeException {
        UpgradePipelineFactory pipelineFactory = (UpgradePipelineFactory)this.appContext.getBean(factoryName, args);
        return pipelineFactory.getPipeline(versionProvider);
    }

    @Override
    public void upgradeSite(String site) {
        logger.info("Checking upgrades for site {0}", site);
        try {
            VersionProvider versionProvider = this.getVersionProvider("siteVersionProvider", site, this.siteVersionFilePath);
            UpgradePipeline pipeline = this.getPipeline(versionProvider, "sitePipelineFactory", new Object[0]);
            pipeline.execute(site);
            this.upgradeSiteConfiguration(site);
        }
        catch (UpgradeException e) {
            logger.error("Error during upgrade for site " + site, e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeSiteConfiguration(String site) throws UpgradeException {
        logger.info("Checking upgrades for configuration in site {0}", site);
        HierarchicalConfiguration config = this.loadUpgradeConfiguration();
        List managedFiles = config.childConfigurationsAt("configurations");
        String configPath = null;
        try {
            for (HierarchicalConfiguration configFile : managedFiles) {
                String module = configFile.getString("module");
                String file = configFile.getString("path");
                List<String> environments = this.getExistingEnvironments(site);
                for (String env : environments) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("module", module);
                    values.put("environment", env);
                    String basePath = StringUtils.isEmpty((CharSequence)env) ? this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern") : this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePathPattern");
                    configPath = Paths.get(StrSubstitutor.replace((Object)basePath, values, (String)"{", (String)"}"), file).toString();
                    logger.info("Checking upgrades for file {0}", configPath);
                    currentFile.set(configPath);
                    VersionProvider versionProvider = this.getVersionProvider("fileVersionProvider", site, configPath);
                    UpgradePipeline pipeline = this.getPipeline(versionProvider, "filePipelineFactory", configFile.getRootElementName() + CONFIG_PIPELINE_SUFFIX);
                    pipeline.execute(site);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error upgrading configuration file {0}", e, configPath);
        }
        finally {
            currentFile.remove();
        }
    }

    @Override
    public void upgradeExistingSites() throws UpgradeException {
        String currentDbVersion = this.dbVersionProvider.getCurrentVersion();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        List sites = currentDbVersion.equals("3.0.0") ? jdbcTemplate.queryForList(SQL_QUERY_SITES_3_0_0, String.class) : jdbcTemplate.queryForList(SQL_QUERY_SITES, String.class);
        for (String site : sites) {
            if (!this.checkIfSiteRepoExists(site)) continue;
            this.upgradeSite(site);
        }
    }

    protected boolean checkIfSiteRepoExists(String site) {
        boolean toRet = false;
        String firstCommitId = this.contentRepository.getRepoFirstCommitId(site);
        if (!StringUtils.isEmpty((CharSequence)firstCommitId)) {
            toRet = true;
        }
        return toRet;
    }

    @Override
    public void upgradeBlueprints() throws UpgradeException {
        logger.info("Checking upgrades for the blueprints", new Object[0]);
        UpgradePipeline pipeline = this.bpPipelineFactory.getPipeline(() -> "3.0.0");
        pipeline.execute();
    }

    @Override
    public List<String> getExistingEnvironments(String site) {
        RepositoryItem[] modules;
        logger.debug("Looking for existing environments in site {0}", site);
        LinkedList<String> result = new LinkedList<String>();
        result.add("");
        String basePath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern");
        String envPath = this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePathPattern");
        for (RepositoryItem module : modules = this.contentRepository.getContentChildren(site, StrSubstitutor.replace((Object)basePath, Collections.singletonMap("module", ""), (String)"{", (String)"}"))) {
            RepositoryItem[] environments;
            logger.debug("Looking for existing environments for module {0} in site {1}", module.name, site);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("module", module.name);
            values.put("environment", "");
            for (RepositoryItem env : environments = this.contentRepository.getContentChildren(site, StrSubstitutor.replace((Object)envPath, values, (String)"{", (String)"}"))) {
                logger.debug("Adding environment {0}", env.name);
                result.add(env.name);
            }
        }
        return result;
    }

    public void init() throws UpgradeException, EntitlementException {
        this.upgradeBlueprints();
        this.upgradeDatabaseAndConfiguration();
        this.upgradeExistingSites();
        try {
            this.integrityValidator.validate(this.dataSource.getConnection());
        }
        catch (SQLException e) {
            logger.error("Could not connect to database for integrity validation", e, new Object[0]);
            throw new UpgradeException("Could not connect to database for integrity validation", e);
        }
    }

    protected HierarchicalConfiguration loadUpgradeConfiguration() throws UpgradeException {
        YamlConfiguration configuration = new YamlConfiguration();
        try (InputStream is = this.configurationFile.getInputStream();){
            configuration.read(is);
        }
        catch (Exception e) {
            throw new UpgradeException("Error reading configuration file", e);
        }
        return configuration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Required
    public void setIntegrityValidator(DbIntegrityValidator integrityValidator) {
        this.integrityValidator = integrityValidator;
    }

    @Required
    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    @Required
    public void setDbPipelineFactory(UpgradePipelineFactory dbPipelineFactory) {
        this.dbPipelineFactory = dbPipelineFactory;
    }

    @Required
    public void setDbVersionProvider(VersionProvider dbVersionProvider) {
        this.dbVersionProvider = dbVersionProvider;
    }

    @Required
    public void setConfigurationFile(Resource configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Required
    public void setSiteVersionFilePath(String siteVersionFilePath) {
        this.siteVersionFilePath = siteVersionFilePath;
    }

    @Required
    public void setBpPipelineFactory(UpgradePipelineFactory bpPipelineFactory) {
        this.bpPipelineFactory = bpPipelineFactory;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

