/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.upgrade.UpgradeOperation;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public abstract class AbstractUpgradeOperation
implements UpgradeOperation,
ServletContextAware,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUpgradeOperation.class);
    public static final String CONFIG_KEY_COMMIT_DETAILS = "commitDetails";
    protected String currentVersion;
    protected String nextVersion;
    protected String commitDetails;
    protected StudioConfiguration studioConfiguration;
    protected DataSource dataSource;
    protected ContentRepository contentRepository;
    protected ServletContext servletContext;
    protected ApplicationContext applicationContext;
    protected GeneralLockService generalLockService;

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public String getProperty(String key) {
        return this.studioConfiguration.getProperty(key);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    @Override
    public void init(String sourceVersion, String targetVersion, HierarchicalConfiguration<ImmutableNode> config) throws UpgradeException {
        this.currentVersion = sourceVersion;
        this.nextVersion = targetVersion;
        this.commitDetails = config.getString(CONFIG_KEY_COMMIT_DETAILS);
        try {
            this.doInit(config);
        }
        catch (ConfigurationException e) {
            throw new UpgradeException("Error initializing operation", (Exception)((Object)e));
        }
    }

    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToRepo(String site, String path, InputStream content) {
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            Path repositoryPath = this.getRepositoryPath(site);
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
            File file = new File(repo.getDirectory().getParent(), path);
            String gitPath = AbstractUpgradeOperation.getGitPath(path);
            File folder = file.getParentFile();
            if (folder != null && !folder.exists()) {
                folder.mkdirs();
            }
            if (!file.exists()) {
                try {
                    if (!file.createNewFile()) {
                        logger.error("error creating file: site: " + site + " path: " + path, new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("error creating file: site: " + site + " path: " + path, e, new Object[0]);
                }
            }
            try (FileChannel outChannel = new FileOutputStream(file.getPath()).getChannel();){
                long count;
                logger.debug("created the file output channel", new Object[0]);
                ReadableByteChannel inChannel = Channels.newChannel(content);
                logger.debug("created the file input channel", new Object[0]);
                long amount = 0x100000L;
                long offset = 0L;
                while ((count = outChannel.transferFrom(inChannel, offset, amount)) > 0L) {
                    logger.debug("writing the bits: offset = " + offset + " count: " + count, new Object[0]);
                    offset += count;
                }
            }
            try {
                var12_15 = null;
                try (Git git = new Git(repo);){
                    git.add().addFilepattern(gitPath).call();
                    Status status = git.status().addPath(gitPath).call();
                    if (status.hasUncommittedChanges() || !status.isClean()) {
                        RevCommit commit = git.commit().setOnly(gitPath).setMessage(this.getCommitMessage()).call();
                        commit.getName();
                    }
                }
                catch (Throwable throwable) {
                    var12_15 = throwable;
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                logger.error("error adding file to git: site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("error writing file: site: " + site + " path: " + path, e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
    }

    protected void commitAllChanges(String site) throws UpgradeException {
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            Path repositoryPath = this.getRepositoryPath(site);
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
            try (Git git = new Git(repo);){
                git.add().addFilepattern(".").call();
                Status status = git.status().call();
                if (status.hasUncommittedChanges() || !status.isClean()) {
                    git.commit().setAll(true).setMessage(this.getCommitMessage()).call();
                }
            }
        }
        catch (IOException | GitAPIException e) {
            throw new UpgradeException("Error committing changes for site " + site, (Exception)e);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
    }

    protected String getCommitMessage() {
        String header = "Site upgrade from v" + this.currentVersion + " to v" + this.nextVersion;
        if (StringUtils.isNotEmpty((CharSequence)this.commitDetails)) {
            return header + ":\n" + this.commitDetails;
        }
        return header;
    }

    private static String getGitPath(String path) {
        Path gitPath = Paths.get(path, new String[0]);
        gitPath = gitPath.normalize();
        try {
            gitPath = Paths.get("/", new String[0]).relativize(gitPath);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Path: " + path + " is already relative path.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)gitPath.toString())) {
            return ".";
        }
        String toRet = gitPath.toString();
        toRet = FilenameUtils.separatorsToUnix((String)toRet);
        return toRet;
    }

    protected Path getRepositoryPath(String site) {
        if (StringUtils.isEmpty((CharSequence)site)) {
            return Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath"), ".git");
        }
        return Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, this.studioConfiguration.getProperty("studio.repo.siteSandboxPath"), ".git");
    }

    protected Resource loadResource(String path) {
        return this.applicationContext.getResource(path);
    }
}

