/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.db;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DbEncryptionUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(DbEncryptionUpgradeOperation.class);
    protected final String REMOTE_REPOSITORIES_QUERY = "select id, remote_password, remote_token, remote_private_key, authentication_type from remote_repository where authentication_type != 'none'";
    protected final String REMOTE_REPOSITORIES_UPDATE = "update remote_repository set remote_password = :remotePassword, remote_token = :remoteToken, remote_private_key = :remotePrivateKey where id = :id";
    protected final String CLUSTER_MEMBERS_QUERY = "select id, git_password, git_token, git_private_key, git_auth_type from cluster where git_auth_type != 'none'";
    protected final String CLUSTER_MEMBERS_UPDATE = "update cluster set git_password = :gitPassword, git_token = :gitToken, git_private_key = :gitPrivateKey where id = :id";
    protected TextEncryptor textEncryptor;

    public DbEncryptionUpgradeOperation(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try {
            NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            this.upgradeRemoteRepositories(jdbcTemplate);
            this.upgradeClusterMembers(jdbcTemplate);
        }
        catch (Exception e) {
            throw new UpgradeException("Error trying to upgrade database", e);
        }
    }

    protected String upgradeValue(String encrypted) throws CryptoException {
        return this.textEncryptor.encrypt(this.textEncryptor.decrypt(encrypted));
    }

    protected void upgradeRemoteRepositories(NamedParameterJdbcTemplate jdbcTemplate) throws CryptoException {
        logger.debug("Looking for remote repositories to upgrade", new Object[0]);
        List remotes = jdbcTemplate.query("select id, remote_password, remote_token, remote_private_key, authentication_type from remote_repository where authentication_type != 'none'", (RowMapper)new BeanPropertyRowMapper(RemoteRepository.class));
        logger.debug("Found {0} remote repositories", remotes.size());
        if (CollectionUtils.isEmpty((Collection)remotes)) {
            return;
        }
        block10: for (RemoteRepository remote : remotes) {
            logger.debug("Upgrading remote repository with id: {0}", remote.getId());
            switch (remote.getAuthenticationType()) {
                case "basic": {
                    remote.setRemotePassword(this.upgradeValue(remote.getRemotePassword()));
                    continue block10;
                }
                case "token": {
                    remote.setRemoteToken(this.upgradeValue(remote.getRemoteToken()));
                    continue block10;
                }
                case "key": {
                    remote.setRemotePrivateKey(this.upgradeValue(remote.getRemotePrivateKey()));
                    continue block10;
                }
            }
            logger.warn("Unknown authentication type {0} for remote repository with id {1}", remote.getAuthenticationType(), remote.getId());
        }
        jdbcTemplate.batchUpdate("update remote_repository set remote_password = :remotePassword, remote_token = :remoteToken, remote_private_key = :remotePrivateKey where id = :id", (SqlParameterSource[])remotes.stream().map(BeanPropertySqlParameterSource::new).toArray(BeanPropertySqlParameterSource[]::new));
    }

    protected void upgradeClusterMembers(NamedParameterJdbcTemplate jdbcTemplate) throws CryptoException {
        logger.debug("Looking for cluster members to upgrade", new Object[0]);
        List members = jdbcTemplate.query("select id, git_password, git_token, git_private_key, git_auth_type from cluster where git_auth_type != 'none'", (RowMapper)new BeanPropertyRowMapper(ClusterMember.class));
        logger.debug("Found {0} cluster members", members.size());
        if (CollectionUtils.isEmpty((Collection)members)) {
            return;
        }
        block10: for (ClusterMember member : members) {
            logger.debug("Upgrading cluster member with id: {0}", member.getId());
            switch (member.getGitAuthType()) {
                case "basic": {
                    member.setGitPassword(this.upgradeValue(member.getGitPassword()));
                    continue block10;
                }
                case "token": {
                    member.setGitToken(this.upgradeValue(member.getGitToken()));
                    continue block10;
                }
                case "key": {
                    member.setGitPrivateKey(this.upgradeValue(member.getGitPrivateKey()));
                    continue block10;
                }
            }
            logger.warn("Unknown authentication type {0} for cluster member with id {1}", member.getGitAuthType(), member.getId());
        }
        jdbcTemplate.batchUpdate("update cluster set git_password = :gitPassword, git_token = :gitToken, git_private_key = :gitPrivateKey where id = :id", (SqlParameterSource[])members.stream().map(BeanPropertySqlParameterSource::new).toArray(BeanPropertySqlParameterSource[]::new));
    }
}

