/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.db;

import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.craftercms.commons.entitlements.validator.DbIntegrityValidator;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.exception.UpgradeNotSupportedException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DbScriptUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(DbScriptUpgradeOperation.class);
    public static final String CONFIG_KEY_FILENAME = "filename";
    public static final String CONFIG_KEY_INTEGRITY = "updateIntegrity";
    public static final String SQL_DELIMITER = " ;";
    protected String scriptFolder;
    protected String fileName;
    protected boolean updateIntegrity;
    protected DbIntegrityValidator integrityValidator;

    public void setUpdateIntegrity(boolean updateIntegrity) {
        this.updateIntegrity = updateIntegrity;
    }

    @Required
    public void setScriptFolder(String scriptFolder) {
        this.scriptFolder = scriptFolder;
    }

    @Required
    public void setIntegrityValidator(DbIntegrityValidator integrityValidator) {
        this.integrityValidator = integrityValidator;
    }

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.fileName = config.getString(CONFIG_KEY_FILENAME);
        this.updateIntegrity = config.getBoolean(CONFIG_KEY_INTEGRITY, true);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try {
            this.integrityValidator.validate(this.getConnection());
        }
        catch (SQLException e) {
            logger.warn("Could not validate database integrity", e);
        }
        catch (Exception e) {
            throw new UpgradeNotSupportedException("The current database version can't be upgraded", e);
        }
        Resource scriptFile = new ClassPathResource(this.scriptFolder).createRelative(this.fileName);
        logger.info("Executing db script {0}", scriptFile.getFilename());
        try (InputStreamReader reader = new InputStreamReader(scriptFile.getInputStream());){
            Connection connection = this.getConnection();
            ScriptRunner scriptRunner = new ScriptRunner(connection);
            scriptRunner.setDelimiter(SQL_DELIMITER);
            scriptRunner.setStopOnError(true);
            scriptRunner.setLogWriter(null);
            scriptRunner.runScript((Reader)reader);
            connection.commit();
            if (this.updateIntegrity) {
                this.integrityValidator.store(connection);
            }
        }
        catch (Exception e) {
            logger.error("Error executing db script", e, new Object[0]);
            throw new UpgradeException("Error executing sql script " + scriptFile.getFilename(), e);
        }
    }
}

