/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;

public class DbVersionUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(DbVersionUpgradeOperation.class);
    private static final String DEFAULT_SQL_COMMAND = "UPDATE _meta SET version = ?";
    protected String sqlCommand = "UPDATE _meta SET version = ?";

    public void setSqlCommand(String sqlCommand) {
        this.sqlCommand = sqlCommand;
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.sqlCommand);){
            statement.setString(1, this.nextVersion);
            int updated = statement.executeUpdate();
            connection.commit();
            if (updated != 1) {
                throw new UpgradeException("Error updating the db version");
            }
            logger.info("Database version updated to {0}", this.nextVersion);
        }
        catch (SQLException e) {
            throw new UpgradeException("Error updating the db version", e);
        }
    }
}

