/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.file;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class AddFileUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AddFileUpgradeOperation.class);
    public static final String CONFIG_KEY_PATH = "path";
    public static final String CONFIG_KEY_FILE = "file";
    protected String path;
    protected Resource file;

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.path = config.getString(CONFIG_KEY_PATH);
        this.file = new ClassPathResource(config.getString(CONFIG_KEY_FILE));
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try (InputStream is = this.file.getInputStream();){
            if (this.contentRepository.contentExists(site, this.path)) {
                logger.info("File {0} already exist in site {1}, it will not be changed", this.path, site);
            } else {
                this.writeToRepo(site, this.path, is);
            }
        }
        catch (IOException e) {
            throw new UpgradeException("Error upgrading file " + this.path + " for site " + site, e);
        }
    }
}

