/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.file;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;

public class DeleteUpgradeOperation
extends AbstractUpgradeOperation {
    public static final String CONFIG_KEY_PATHS = "paths";
    protected String[] paths;

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.paths = (String[])config.getArray(String.class, CONFIG_KEY_PATHS);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        for (String path : this.paths) {
            try {
                Path pathToDelete = Paths.get(this.getRepositoryPath(site).getParent().toAbsolutePath().toString(), path);
                File f = pathToDelete.toFile();
                if (!f.exists()) continue;
                FileUtils.forceDelete((File)f);
            }
            catch (Exception e) {
                throw new UpgradeException("Error deleting path " + path + " to path for repo " + (StringUtils.isEmpty((CharSequence)site) ? "global" : site), e);
            }
        }
        this.commitAllChanges(site);
    }
}

