/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;

public class RenameUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(RenameUpgradeOperation.class);
    public static final String CONFIG_KEY_OLD_PATH = "oldPath";
    public static final String CONFIG_KEY_NEW_PATH = "newPath";
    public static final String CONFIG_KEY_OVERWRITE = "overwrite";
    protected String oldPath;
    protected String newPath;
    protected boolean overwrite;

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.oldPath = config.getString(CONFIG_KEY_OLD_PATH);
        this.newPath = config.getString(CONFIG_KEY_NEW_PATH);
        this.overwrite = config.getBoolean(CONFIG_KEY_OVERWRITE, false);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try {
            Path repo = this.getRepositoryPath(site).getParent().toAbsolutePath();
            Path from = repo.resolve(this.oldPath);
            Path to = repo.resolve(this.newPath);
            this.renamePath(from, to);
            this.commitAllChanges(site);
        }
        catch (Exception e) {
            throw new UpgradeException("Error moving path " + this.oldPath + " to path " + this.newPath + " for repo " + (StringUtils.isEmpty((CharSequence)site) ? "global" : site), e);
        }
    }

    protected void renamePath(Path from, Path to) throws IOException {
        File fromFile = from.toFile();
        File toFile = to.toFile();
        if (fromFile.exists()) {
            if (toFile.exists()) {
                if (this.overwrite) {
                    FileUtils.forceDelete((File)toFile);
                } else {
                    logger.info("Rename operation not executed because target path {0} already exists.", to);
                    return;
                }
            }
            if (fromFile.isDirectory()) {
                FileUtils.moveDirectory((File)fromFile, (File)toFile);
            } else if (fromFile.isFile()) {
                FileUtils.moveFile((File)fromFile, (File)toFile);
            }
        }
    }
}

