/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.file.RenameUpgradeOperation;

public class TemplateRenameUpgradeOperation
extends RenameUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(TemplateRenameUpgradeOperation.class);
    public static final String CONFIG_KEY_BASE_PATH = "basePath";
    protected String basePath;

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        this.basePath = config.getString(CONFIG_KEY_BASE_PATH);
        this.oldPath = StringUtils.removeStart((String)this.oldPath, (String)File.separator);
        this.newPath = StringUtils.removeStart((String)this.newPath, (String)File.separator);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        Path repo = this.getRepositoryPath(site).getParent();
        Path base = StringUtils.isNotEmpty((CharSequence)this.basePath) ? repo.resolve(StringUtils.removeStart((String)this.basePath, (String)File.separator)) : repo;
        try {
            List matches = Files.walk(base, new FileVisitOption[0]).filter(path -> base.relativize((Path)path).toString().matches(this.oldPath)).map(base::relativize).collect(Collectors.toList());
            logger.debug("Found {0} matches in site {1}", matches.size(), site);
            for (Path matchedPath : matches) {
                logger.debug("Processing file {0} in site {1}", matchedPath, site);
                Matcher matcher = Pattern.compile(this.oldPath).matcher(matchedPath.toString());
                if (!matcher.matches()) continue;
                String actualPath = this.newPath;
                int total = matcher.groupCount();
                for (int i = 1; i <= total; ++i) {
                    actualPath = actualPath.replace("$" + i, matcher.group(i));
                }
                logger.debug("Renaming file {0} to {1} in site {2}", matchedPath, actualPath, site);
                this.renamePath(base.resolve(matchedPath), base.resolve(actualPath));
            }
            this.commitAllChanges(site);
        }
        catch (IOException e) {
            throw new UpgradeException("Error renaming files " + this.oldPath + " to " + this.newPath + " in site " + site, e);
        }
    }
}

