/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.global;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.monitoring.VersionInfo;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.impl.v1.repository.git.TreeCopier;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.springframework.beans.factory.annotation.Required;

public class BlueprintsUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(BlueprintsUpgradeOperation.class);
    private static final String STUDIO_MANIFEST_LOCATION = "/META-INF/MANIFEST.MF";
    protected ServicesConfig servicesConfig;
    protected SecurityService securityService;
    protected UserServiceInternal userServiceInternal;
    protected TextEncryptor encryptor;
    protected GeneralLockService generalLockService;
    protected RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;

    @Required
    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public TextEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    @Override
    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public RetryingRepositoryOperationFacade getRetryingRepositoryOperationFacade() {
        return this.retryingRepositoryOperationFacade;
    }

    public void setRetryingRepositoryOperationFacade(RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) {
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
    }

    @Override
    public void execute(String site) throws UpgradeException {
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Path globalConfigPath = helper.buildRepoPath(GitRepositories.GLOBAL);
            Path blueprintsPath = Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
            String studioManifestLocation = this.servletContext.getRealPath(STUDIO_MANIFEST_LOCATION);
            String blueprintsManifestLocation = Paths.get(blueprintsPath.toAbsolutePath().toString(), "BLUEPRINTS.MF").toAbsolutePath().toString();
            boolean blueprintManifestExists = Files.exists(Paths.get(blueprintsManifestLocation, new String[0]), new LinkOption[0]);
            FileInputStream studioManifestStream = FileUtils.openInputStream((File)new File(studioManifestLocation));
            Manifest studioManifest = new Manifest(studioManifestStream);
            VersionInfo studioVersion = VersionInfo.getVersion((Manifest)studioManifest);
            FileInputStream blueprintsManifestStream = null;
            Manifest blueprintsManifest = null;
            VersionInfo blueprintsVersion = null;
            if (blueprintManifestExists) {
                blueprintsManifestStream = FileUtils.openInputStream((File)new File(blueprintsManifestLocation));
                blueprintsManifest = new Manifest(blueprintsManifestStream);
                blueprintsVersion = VersionInfo.getVersion((Manifest)blueprintsManifest);
            }
            if (!blueprintManifestExists || !StringUtils.equals((CharSequence)studioVersion.getPackageBuild(), (CharSequence)blueprintsVersion.getPackageBuild()) || StringUtils.equals((CharSequence)studioVersion.getPackageBuild(), (CharSequence)blueprintsVersion.getPackageBuild()) && !StringUtils.equals((CharSequence)studioVersion.getPackageBuildDate(), (CharSequence)blueprintsVersion.getPackageBuildDate())) {
                File[] blueprintFolders;
                String bootstrapBlueprintsFolderPath = this.servletContext.getRealPath("/repo-bootstrap/global/" + this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
                File bootstrapBlueprintsFolder = new File(bootstrapBlueprintsFolderPath);
                for (File blueprintFolder : blueprintFolders = bootstrapBlueprintsFolder.listFiles(File::isDirectory)) {
                    String blueprintName = blueprintFolder.getName();
                    FileUtils.deleteDirectory((File)Paths.get(blueprintsPath.toAbsolutePath().toString(), blueprintName).toFile());
                    TreeCopier tc = new TreeCopier(Paths.get(blueprintFolder.getAbsolutePath(), new String[0]), Paths.get(blueprintsPath.toAbsolutePath().toString(), blueprintName));
                    EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                    Files.walkFileTree(Paths.get(blueprintFolder.getAbsolutePath(), new String[0]), opts, Integer.MAX_VALUE, tc);
                }
                FileUtils.copyFile((File)Paths.get(studioManifestLocation, new String[0]).toFile(), (File)Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"), "BLUEPRINTS.MF").toFile());
            }
            Repository globalRepo = helper.getRepository(site, GitRepositories.GLOBAL);
            try (Git git = new Git(globalRepo);){
                StatusCommand statusCommand = git.status();
                Status status = (Status)this.retryingRepositoryOperationFacade.call(statusCommand);
                if (status.hasUncommittedChanges() || !status.isClean()) {
                    AddCommand addCommand = git.add().addFilepattern(".");
                    this.retryingRepositoryOperationFacade.call(addCommand);
                    CommitCommand commitCommand = git.commit().setAll(true).setMessage(this.studioConfiguration.getProperty("studio.repo.blueprintsUpdated.commitMessage"));
                    this.retryingRepositoryOperationFacade.call(commitCommand);
                }
            }
            catch (GitAPIException err) {
                logger.error("error creating initial commit for global configuration", (Exception)((Object)err), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Error upgrading blueprints in the global repo", e);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
    }
}

