/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.global;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.job.StudioClusterGlobalRepoSyncTask;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.core.io.Resource;

public class GlobalRepoUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(GlobalRepoUpgradeOperation.class);
    public static final String CONFIG_KEY_FILES = "files";
    public static final String CONFIG_KEY_SRC = "src";
    public static final String CONFIG_KEY_DEST = "dest";
    public static final String CONFIG_KEY_OVERWRITE = "overwrite";
    protected Map<Resource, String> files = new HashMap<Resource, String>();
    protected boolean overwrite;
    protected StudioClusterGlobalRepoSyncTask clusterGlobalRepoSyncTask;

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.overwrite = config.getBoolean(CONFIG_KEY_OVERWRITE, true);
        List fileMappings = config.configurationsAt(CONFIG_KEY_FILES);
        for (HierarchicalConfiguration fileMapping : fileMappings) {
            String src = fileMapping.getString(CONFIG_KEY_SRC);
            String dest = fileMapping.getString(CONFIG_KEY_DEST);
            if (StringUtils.isEmpty((CharSequence)src)) {
                throw new IllegalStateException("'src' config key not specified");
            }
            if (StringUtils.isEmpty((CharSequence)dest)) {
                throw new IllegalStateException("'dest' config key not specified");
            }
            this.files.put(this.loadResource(src), dest);
        }
    }

    @Override
    public void execute(String site) throws UpgradeException {
        logger.debug("Upgrading global repo files", new Object[0]);
        this.clusterGlobalRepoSyncTask.execute();
        for (Map.Entry<Resource, String> entry : this.files.entrySet()) {
            if (this.overwrite || !this.contentRepository.contentExists(site, entry.getValue())) {
                logger.debug("Upgrading global repo file: {0}", entry.getValue());
                try {
                    InputStream is = entry.getKey().getInputStream();
                    Throwable throwable = null;
                    try {
                        this.writeToRepo(site, entry.getValue(), is);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new UpgradeException("Error while upgrading global repo file " + entry.getValue(), e);
                }
            }
            logger.debug("File {0} already exists in global repo, it will not be changed", entry.getValue());
        }
    }

    public StudioClusterGlobalRepoSyncTask getClusterGlobalRepoSyncTask() {
        return this.clusterGlobalRepoSyncTask;
    }

    public void setClusterGlobalRepoSyncTask(StudioClusterGlobalRepoSyncTask clusterGlobalRepoSyncTask) {
        this.clusterGlobalRepoSyncTask = clusterGlobalRepoSyncTask;
    }
}

