/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.plugin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.DisableClassLoadingConstructor;
import org.craftercms.commons.plugin.PluginDescriptorReader;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.beans.factory.annotation.Required;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractPluginDescriptorUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPluginDescriptorUpgradeOperation.class);
    public static final String CONFIG_KEY_DESCRIPTOR_PATH = "descriptorPath";
    public static final String CONFIG_KEY_DESCRIPTOR_VERSION = "descriptorVersion";
    protected PluginDescriptorReader descriptorReader;
    protected String descriptorPath;
    protected String descriptorVersion;

    @Required
    public void setDescriptorReader(PluginDescriptorReader descriptorReader) {
        this.descriptorReader = descriptorReader;
    }

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.descriptorPath = config.getString(CONFIG_KEY_DESCRIPTOR_PATH);
        this.descriptorVersion = config.getString(CONFIG_KEY_DESCRIPTOR_VERSION);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        Path descriptorFile = this.getRepositoryPath(site).getParent().resolve(this.descriptorPath);
        if (Files.notExists(descriptorFile, new LinkOption[0])) {
            logger.info("Plugin descriptor file not found for site {0}", site);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(descriptorFile);){
            PluginDescriptor descriptor = this.descriptorReader.read((Reader)reader);
            if (descriptor.getDescriptorVersion().equals(this.descriptorVersion)) {
                logger.info("Plugin descriptor already update for site " + site, new Object[0]);
                return;
            }
            logger.info("Updating plugin descriptor for site " + site, new Object[0]);
            this.doPluginDescriptorUpdates(descriptor);
            descriptor.setDescriptorVersion(this.descriptorVersion);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            Yaml yaml = new Yaml((BaseConstructor)new DisableClassLoadingConstructor(), new Representer(){

                protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                    if (propertyValue != null) {
                        return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
                    }
                    return null;
                }
            }, options);
            String content = yaml.dumpAsMap((Object)descriptor);
            this.writeToRepo(site, this.descriptorPath, new ByteArrayInputStream(content.getBytes()));
            this.commitAllChanges(site);
        }
        catch (Exception e) {
            throw new UpgradeException("Plugin descriptor can't be read for site " + site);
        }
    }

    protected abstract void doPluginDescriptorUpdates(PluginDescriptor var1) throws UpgradeException;
}

