/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.plugin.model.Asset;
import org.craftercms.commons.plugin.model.BlueprintDescriptor;
import org.craftercms.commons.plugin.model.Build;
import org.craftercms.commons.plugin.model.Contact;
import org.craftercms.commons.plugin.model.Developer;
import org.craftercms.commons.plugin.model.Link;
import org.craftercms.commons.plugin.model.Media;
import org.craftercms.commons.plugin.model.Plugin;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.commons.plugin.model.Version;
import org.craftercms.studio.impl.v2.upgrade.operations.plugin.AbstractPluginDescriptorUpgradeOperation;

public class DescriptorV2UpgradeOperation
extends AbstractPluginDescriptorUpgradeOperation {
    @Override
    protected void doPluginDescriptorUpdates(PluginDescriptor descriptor) {
        BlueprintDescriptor.Blueprint blueprint = descriptor.getBlueprint();
        Plugin plugin = new Plugin();
        plugin.setType("blueprint");
        plugin.setId(blueprint.getId());
        plugin.setName(blueprint.getName());
        plugin.setDescription(blueprint.getDescription());
        plugin.setTags(Arrays.asList(blueprint.getTags().split(",")));
        plugin.setSearchEngine(blueprint.getSearchEngine());
        Version pluginVersion = new Version();
        pluginVersion.setMajor(blueprint.getVersion().getMajor());
        pluginVersion.setMinor(blueprint.getVersion().getMinor());
        pluginVersion.setPatch(blueprint.getVersion().getPatch());
        plugin.setVersion(pluginVersion);
        Build build = new Build();
        build.setId(blueprint.getBuild().getId());
        build.setDate(blueprint.getBuild().getDate());
        plugin.setBuild(build);
        Link license = new Link();
        license.setName(blueprint.getLicense().getName());
        license.setUrl(blueprint.getLicense().getUrl());
        plugin.setLicense(license);
        Link website = new Link();
        website.setName(blueprint.getWebsite().getName());
        website.setUrl(blueprint.getWebsite().getUrl());
        plugin.setWebsite(website);
        Media media = new Media();
        if (Objects.nonNull(blueprint.getMedia()) && CollectionUtils.isNotEmpty((Collection)blueprint.getMedia().getScreenshots())) {
            media.setScreenshots(blueprint.getMedia().getScreenshots().stream().map(oldScreenshot -> {
                Asset screenshot = new Asset();
                screenshot.setTitle(oldScreenshot.getScreenshot().getTitle());
                screenshot.setDescription(oldScreenshot.getScreenshot().getDescription());
                screenshot.setUrl(oldScreenshot.getScreenshot().getUrl());
                return screenshot;
            }).collect(Collectors.toList()));
        }
        if (Objects.nonNull(blueprint.getMedia()) && CollectionUtils.isNotEmpty((Collection)blueprint.getMedia().getVideos())) {
            media.setVideos(blueprint.getMedia().getVideos().stream().map(oldVideo -> {
                Asset video = new Asset();
                video.setTitle(oldVideo.getVideo().getTitle());
                video.setDescription(oldVideo.getVideo().getDescription());
                video.setUrl(oldVideo.getVideo().getUrl());
                return video;
            }).collect(Collectors.toList()));
        }
        plugin.setMedia(media);
        plugin.setCrafterCmsVersions(blueprint.getCraftercmsVersionsSupported().stream().map(oldVersion -> {
            String[] values = oldVersion.getVersion().split("\\.");
            Version version = new Version();
            version.setMajor(Integer.parseInt(values[0]));
            version.setMinor(Integer.parseInt(values[1]));
            version.setPatch(Integer.parseInt(values[2]));
            return version;
        }).collect(Collectors.toList()));
        Developer developer = new Developer();
        if (Objects.nonNull(blueprint.getMedia()) && Objects.nonNull(blueprint.getMedia().getDeveloper()) && CollectionUtils.isNotEmpty((Collection)blueprint.getMedia().getDeveloper().getPeople())) {
            developer.setPeople(blueprint.getMedia().getDeveloper().getPeople().stream().map(oldDev -> {
                Contact dev = new Contact();
                dev.setName(oldDev.getPerson().getName());
                dev.setEmail(oldDev.getPerson().getEmail());
                dev.setUrl(oldDev.getPerson().getUrl());
                return dev;
            }).collect(Collectors.toList()));
        }
        if (Objects.nonNull(blueprint.getMedia()) && Objects.nonNull(blueprint.getMedia().getDeveloper()) && Objects.nonNull(blueprint.getMedia().getDeveloper().getCompany())) {
            Contact company = new Contact();
            company.setName(blueprint.getMedia().getDeveloper().getCompany().getName());
            company.setEmail(blueprint.getMedia().getDeveloper().getCompany().getEmail());
            company.setUrl(blueprint.getMedia().getDeveloper().getCompany().getUrl());
            developer.setCompany(company);
        }
        plugin.setDeveloper(developer);
        plugin.setCrafterCmsEditions(Collections.singletonList("community"));
        descriptor.setPlugin(plugin);
        descriptor.setBlueprint(null);
    }
}

