/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractContentUpgradeOperation;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Document;

public abstract class AbstractContentTypeUpgradeOperation
extends AbstractContentUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContentTypeUpgradeOperation.class);
    public static final String CONFIG_KEY_CONTENT_TYPES = "includedContentTypes";
    public static final String CONFIG_KEY_FORM_DEFINITION = "formDefinitionXpath";
    public static final String CONFIG_KEY_MAX_ITEMS = "maxCacheItems";
    public static final String NAME_PLACEHOLDER = "\\{name}";
    public static final int DEFAULT_MAX_ITEMS = 200;
    protected List<String> includedContentTypes;
    protected String formDefinitionXpath;
    protected String contentTypeXpath;
    protected String formDefinitionTemplate;
    protected Cache<Path, Document> cache;
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected XPathFactory xPathFactory = XPathFactory.newInstance();
    protected TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Required
    public void setContentTypeXpath(String contentTypeXpath) {
        this.contentTypeXpath = contentTypeXpath;
    }

    @Required
    public void setFormDefinitionTemplate(String formDefinitionTemplate) {
        this.formDefinitionTemplate = formDefinitionTemplate;
    }

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        this.includedContentTypes = config.getList(String.class, CONFIG_KEY_CONTENT_TYPES);
        this.formDefinitionXpath = config.getString(CONFIG_KEY_FORM_DEFINITION);
        int maxCacheItems = config.getInt(CONFIG_KEY_MAX_ITEMS, 200);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxCacheItems).build();
    }

    @Override
    protected boolean shouldBeUpdated(String site, Path file) throws UpgradeException {
        logger.debug("Checking file {0} for site {1}", file, site);
        try {
            Document document = this.loadDocument(file);
            String contentTypeName = (String)this.select(document, this.contentTypeXpath, XPathConstants.STRING);
            if (CollectionUtils.isNotEmpty(this.includedContentTypes) && !this.includedContentTypes.contains(contentTypeName)) {
                logger.debug("File {0} of content-type {1} will not be updated", file, contentTypeName);
                return false;
            }
            if (StringUtils.isNotEmpty((String)this.formDefinitionXpath)) {
                Path formDefinition = this.getFormDefinition(site, contentTypeName);
                document = this.loadDocument(formDefinition);
                return (Boolean)this.select(document, this.formDefinitionXpath, XPathConstants.BOOLEAN);
            }
            return true;
        }
        catch (ExecutionException e) {
            logger.error("Invalid XML file found at " + file, e, new Object[0]);
            return false;
        }
        catch (Exception e) {
            throw new UpgradeException("Error parsing xml file " + file, e);
        }
    }

    protected Document loadDocument(Path file) throws ExecutionException {
        return (Document)this.cache.get((Object)file, () -> {
            logger.debug("Parsing file {0}", file);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            return builder.parse(file.toFile());
        });
    }

    protected Path getFormDefinition(String site, String contentTypeName) {
        return this.getRepositoryPath(site).getParent().resolve(this.formDefinitionTemplate.replaceFirst(NAME_PLACEHOLDER, contentTypeName));
    }

    protected Object select(Object source, String xpath, QName type) throws XPathExpressionException {
        return this.xPathFactory.newXPath().compile(xpath).evaluate(source, type);
    }

    protected void writeFile(Path file, Document document) throws UpgradeException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new UpgradeException("Error writing file " + file, e);
        }
    }
}

