/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;

public abstract class AbstractContentUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContentUpgradeOperation.class);
    public static final String CONFIG_KEY_INCLUDED_PATHS = "includedPaths";
    protected List<String> includedPaths;

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        this.includedPaths = config.getList(String.class, CONFIG_KEY_INCLUDED_PATHS);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        try {
            List<Path> includedPaths = this.findIncludedPaths(site);
            List<Path> filteredPaths = this.filterPaths(site, includedPaths);
            if (CollectionUtils.isNotEmpty(filteredPaths)) {
                for (Path file : filteredPaths) {
                    this.updateFile(site, file);
                }
            }
        }
        catch (IOException e) {
            throw new UpgradeException("Error reading content for site " + site, e);
        }
        finally {
            this.commitAllChanges(site);
        }
    }

    protected List<Path> findIncludedPaths(String site) throws IOException {
        if (CollectionUtils.isNotEmpty(this.includedPaths)) {
            Path repo = this.getRepositoryPath(site).getParent();
            ListFileVisitor fileVisitor = new ListFileVisitor(repo, this.includedPaths);
            Files.walkFileTree(repo, fileVisitor);
            return fileVisitor.getMatchedPaths();
        }
        return null;
    }

    protected List<Path> filterPaths(String site, List<Path> matchedPaths) throws UpgradeException {
        if (CollectionUtils.isNotEmpty(matchedPaths)) {
            LinkedList<Path> filteredPaths = new LinkedList<Path>();
            for (Path path : matchedPaths) {
                if (!this.shouldBeUpdated(site, path)) continue;
                filteredPaths.add(path);
            }
            return filteredPaths;
        }
        return null;
    }

    protected abstract boolean shouldBeUpdated(String var1, Path var2) throws UpgradeException;

    protected abstract void updateFile(String var1, Path var2) throws UpgradeException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(Path path) throws UpgradeException {
        logger.debug("Reading content for file {0}", path);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
        catch (IOException e) {
            throw new UpgradeException("Error reading file " + path, e);
        }
    }

    protected void writeFile(Path path, String content) throws UpgradeException {
        logger.debug("Writing content for file {0}", path);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            IOUtils.write((String)content, (OutputStream)os);
        }
        catch (IOException e) {
            throw new UpgradeException("Error writing file " + path, e);
        }
    }

    public class ListFileVisitor
    implements FileVisitor<Path> {
        protected Path rootPath;
        protected List<String> includedPaths;
        protected List<Path> matchedPaths = new LinkedList<Path>();

        public ListFileVisitor(Path rootPath, List<String> includedPaths) {
            this.rootPath = rootPath;
            this.includedPaths = includedPaths;
        }

        public List<Path> getMatchedPaths() {
            return this.matchedPaths;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            String relativePath = this.rootPath.relativize(file).toString();
            if (RegexUtils.matchesAny((String)relativePath, this.includedPaths)) {
                this.matchedPaths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            logger.error("Could not read file " + file, exc, new Object[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

