/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class AbstractXsltFileUpgradeOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractXsltFileUpgradeOperation.class);
    public static final String CONFIG_KEY_TEMPLATE = "template";
    protected static final String SAXON_CLASS = "net.sf.saxon.TransformerFactoryImpl";
    protected Resource template;

    public void setTemplate(Resource template) {
        this.template = template;
    }

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        if (this.template == null) {
            this.template = new ClassPathResource(config.getString(CONFIG_KEY_TEMPLATE));
        }
    }

    protected void executeTemplate(String site, String path, OutputStream os) throws UpgradeException {
        block27: {
            if (this.contentRepository.contentExists(site, path)) {
                try (InputStream templateIs = this.template.getInputStream();){
                    Transformer transformer = TransformerFactory.newInstance(SAXON_CLASS, null).newTransformer(new StreamSource(templateIs));
                    logger.info("Applying XSLT template {0} to file {1} for site {2}", this.template, path, site);
                    try (InputStream sourceIs = this.contentRepository.getContent(site, path);){
                        transformer.setParameter("site_id", site);
                        transformer.setParameter("version", this.nextVersion);
                        transformer.setURIResolver(this.getURIResolver(site));
                        transformer.transform(new StreamSource(sourceIs), new StreamResult(os));
                        break block27;
                    }
                }
                catch (Exception e) {
                    throw new UpgradeException("Error processing file", e);
                }
            }
            logger.warn("Source file {0} does not exist in site {1}", path, site);
        }
    }

    protected URIResolver getURIResolver(final String siteId) {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                try {
                    Path resolverPath = null;
                    resolverPath = StringUtils.isEmpty((CharSequence)siteId) ? Paths.get(AbstractXsltFileUpgradeOperation.this.studioConfiguration.getProperty("studio.repo.basePath"), AbstractXsltFileUpgradeOperation.this.studioConfiguration.getProperty("studio.repo.globalRepoPath"), href) : Paths.get(AbstractXsltFileUpgradeOperation.this.studioConfiguration.getProperty("studio.repo.basePath"), AbstractXsltFileUpgradeOperation.this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, AbstractXsltFileUpgradeOperation.this.studioConfiguration.getProperty("studio.repo.siteSandboxPath"), href);
                    return new StreamSource(resolverPath.toAbsolutePath().toFile());
                }
                catch (Exception e) {
                    logger.info("Error creating resolver for referencing documents inside xslt forms", e);
                    return null;
                }
            }
        };
    }
}

