/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.AbstractUpgradeOperation;

public class AddSiteUuidOperation
extends AbstractUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(AddSiteUuidOperation.class);
    private SiteFeedMapper siteFeedMapper;

    @Override
    public void execute(String site) throws UpgradeException {
        logger.debug("Get site data from database for site " + site, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        SiteFeed siteFeed = this.siteFeedMapper.getSite(params);
        if (siteFeed != null) {
            try {
                logger.debug("Add UUID file for site " + site, new Object[0]);
                this.addSiteUuidFile(site, siteFeed.getSiteUuid());
            }
            catch (IOException e) {
                throw new UpgradeException("Error when adding UUID file for site " + site, e);
            }
        }
    }

    private void addSiteUuidFile(String site, String siteUuid) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)siteUuid)) {
            Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, "site-uuid.txt");
            String toWrite = "# THIS IS A SYSTEM FILE. PLEASE DO NOT EDIT NOR DELETE IT!!!\n" + siteUuid;
            logger.debug("Write UUID " + siteUuid + " to the file " + path.toString() + " for site " + site, new Object[0]);
            Files.write(path, toWrite.getBytes(), new OpenOption[0]);
        }
    }

    public SiteFeedMapper getSiteFeedMapper() {
        return this.siteFeedMapper;
    }

    public void setSiteFeedMapper(SiteFeedMapper siteFeedMapper) {
        this.siteFeedMapper = siteFeedMapper;
    }
}

