/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractXsltFileUpgradeOperation;

public class BatchXsltFileUpgradeOperation
extends AbstractXsltFileUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(BatchXsltFileUpgradeOperation.class);
    public static final String CONFIG_KEY_REGEX = "regex";
    protected String regex;

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        this.regex = config.getString(CONFIG_KEY_REGEX);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        logger.debug("Looking site {0} for files that match: {1}", site, this.regex);
        Path repository = this.getRepositoryPath(site).getParent();
        try (Stream<Path> paths = Files.find(repository, Integer.MAX_VALUE, (path, attrs) -> repository.relativize((Path)path).toString().matches(this.regex), new FileVisitOption[0]);){
            paths.forEach(path -> {
                logger.debug("Executing XSLT template in site {0} for file {1}", site, path);
                try {
                    Path temp = Files.createTempFile("upgrade-manager", "xslt", new FileAttribute[0]);
                    try {
                        OutputStream os = Files.newOutputStream(temp, new OpenOption[0]);
                        this.executeTemplate(site, repository.relativize((Path)path).toString(), os);
                        os.close();
                        if (Files.size(temp) > 0L) {
                            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    finally {
                        Files.deleteIfExists(temp);
                    }
                }
                catch (Exception e) {
                    logger.error("Error upgrading file {0} in site {1}", e, site, path);
                }
            });
            this.commitAllChanges(site);
        }
        catch (IOException e) {
            throw new UpgradeException("Error searching for files in site " + site, e);
        }
    }
}

