/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractContentTypeUpgradeOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoxRemoteAssetUpgradeOperation
extends AbstractContentTypeUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(BoxRemoteAssetUpgradeOperation.class);
    public static final String CONFIG_KEY_FIELD_XPATH = "fieldNameXpath";
    public static final String CONFIG_KEY_PROFILE_XPATH = "profileIdXpath";
    public static final String CONFIG_KEY_ITEM_XPATH = "itemXpath";
    public static final String CONFIG_KEY_ITEM_ID_XPATH = "itemIdXpath";
    public static final String CONFIG_KEY_ITEM_NAME_XPATH = "itemNameXpath";
    public static final String CONFIG_KEY_URL_NAME = "urlElementName";
    public static final String CONFIG_KEY_URL_TEMPLATE = "urlTemplate";
    public static final String PLACEHOLDER_PROFILE = "profile";
    public static final String PLACEHOLDER_ID = "id";
    public static final String PLACEHOLDER_EXTENSION = "extension";
    protected String fieldNameXpath;
    protected String profileIdXpath;
    protected String itemXpath;
    protected String itemIdXpath;
    protected String itemNameXpath;
    protected String urlElementName;
    protected String urlTemplate;

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        this.fieldNameXpath = config.getString(CONFIG_KEY_FIELD_XPATH);
        this.profileIdXpath = config.getString(CONFIG_KEY_PROFILE_XPATH);
        this.itemXpath = config.getString(CONFIG_KEY_ITEM_XPATH);
        this.itemIdXpath = config.getString(CONFIG_KEY_ITEM_ID_XPATH);
        this.itemNameXpath = config.getString(CONFIG_KEY_ITEM_NAME_XPATH);
        this.urlElementName = config.getString(CONFIG_KEY_URL_NAME);
        this.urlTemplate = config.getString(CONFIG_KEY_URL_TEMPLATE);
    }

    @Override
    protected void updateFile(String site, Path file) throws UpgradeException {
        try {
            Document descriptor = this.loadDocument(file);
            String contentTypeName = (String)this.select(descriptor, this.contentTypeXpath, XPathConstants.STRING);
            Path formDefinition = this.getFormDefinition(site, contentTypeName);
            Document definition = this.loadDocument(formDefinition);
            NodeList formFields = (NodeList)this.select(definition, this.fieldNameXpath, XPathConstants.NODESET);
            logger.debug("Found {0} Box controls for content-type {1}", formFields.getLength(), contentTypeName);
            boolean updated = false;
            for (int i = 0; i < formFields.getLength(); ++i) {
                Node formField = formFields.item(i);
                updated = this.findFields(file, definition, descriptor, formField) || updated;
            }
            if (updated) {
                logger.info("Updating file {0}", file);
                this.writeFile(file, descriptor);
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Error updating descriptor for file " + file, e);
        }
    }

    protected boolean findFields(Path file, Document definition, Document descriptor, Node formField) throws XPathExpressionException {
        String fieldName = formField.getTextContent();
        Map<String, String> idValue = Collections.singletonMap(PLACEHOLDER_ID, fieldName);
        String profileId = (String)this.select(definition, StrSubstitutor.replace((Object)this.profileIdXpath, idValue), XPathConstants.STRING);
        NodeList items = (NodeList)this.select(descriptor, StrSubstitutor.replace((Object)this.itemXpath, idValue), XPathConstants.NODESET);
        logger.debug("Found {0} Box fields in file {1}", items.getLength(), file);
        boolean updated = false;
        for (int j = 0; j < items.getLength(); ++j) {
            Node item = items.item(j);
            updated = this.updateField(descriptor, item, profileId, fieldName) || updated;
        }
        return updated;
    }

    protected boolean updateField(Document descriptor, Node item, String profileId, String fieldName) throws XPathExpressionException {
        String fileId = (String)this.select(item, this.itemIdXpath, XPathConstants.STRING);
        String fileName = (String)this.select(item, this.itemNameXpath, XPathConstants.STRING);
        if (!((Boolean)this.select(item, this.urlElementName, XPathConstants.BOOLEAN)).booleanValue()) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(PLACEHOLDER_PROFILE, profileId);
            values.put(PLACEHOLDER_ID, fileId);
            values.put(PLACEHOLDER_EXTENSION, FilenameUtils.getExtension((String)fileName));
            String urlValue = StrSubstitutor.replace((Object)this.urlTemplate, values);
            logger.debug("Adding url element for field {0}/{1} with value {2}", fieldName, fileId, urlValue);
            Element urlNode = descriptor.createElement(this.urlElementName);
            urlNode.setTextContent(urlValue);
            item.appendChild(urlNode);
            return true;
        }
        logger.info("Field {0}/{1} already has a {2} element, it will not be updated", fieldName, fileId, this.urlElementName);
        return false;
    }
}

