/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractContentUpgradeOperation;

public class ConfigEncryptionUpgradeOperation
extends AbstractContentUpgradeOperation {
    protected static String DEFAULT_ENCRYPTED_PATTERN = "\\$\\{enc:([^}#]+)}";
    protected Pattern encryptedPattern = Pattern.compile(DEFAULT_ENCRYPTED_PATTERN);
    protected TextEncryptor textEncryptor;

    public ConfigEncryptionUpgradeOperation(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    protected boolean shouldBeUpdated(String site, Path file) {
        return true;
    }

    @Override
    protected void updateFile(String site, Path path) throws UpgradeException {
        try {
            String content = this.readFile(path);
            Matcher matcher = this.encryptedPattern.matcher(content);
            boolean updateFile = matcher.matches();
            while (matcher.find()) {
                String encryptedValue = matcher.group(1);
                String originalValue = this.textEncryptor.decrypt(encryptedValue);
                String newValue = this.textEncryptor.encrypt(originalValue);
                content = content.replaceAll(encryptedValue, newValue);
                updateFile = true;
            }
            if (updateFile) {
                this.writeFile(path, content);
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Error updating file " + path + " for site " + site, e);
        }
    }
}

