/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.nio.file.Path;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractContentUpgradeOperation;

public class FindAndReplaceUpgradeOperation
extends AbstractContentUpgradeOperation {
    private static final Logger logger = LoggerFactory.getLogger(FindAndReplaceUpgradeOperation.class);
    public static final String CONFIG_KEY_PATTERN = "pattern";
    public static final String CONFIG_KEY_REPLACEMENT = "replacement";
    protected String pattern;
    protected String replacement;

    @Override
    protected void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        this.pattern = config.getString(CONFIG_KEY_PATTERN);
        this.replacement = config.getString(CONFIG_KEY_REPLACEMENT);
    }

    @Override
    protected boolean shouldBeUpdated(String site, Path file) {
        return true;
    }

    @Override
    protected void updateFile(String site, Path path) throws UpgradeException {
        String content = this.readFile(path);
        String updated = null;
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            updated = StringUtils.replaceAll((String)content, (String)this.pattern, (String)this.replacement);
        }
        if (StringUtils.isNotEmpty(updated) && !StringUtils.equals((CharSequence)content, updated)) {
            logger.info("Updating file {0}", path);
            this.writeFile(path, updated);
        }
    }
}

