/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.operations.site;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.impl.v2.upgrade.DefaultUpgradeManagerImpl;
import org.craftercms.studio.impl.v2.upgrade.operations.site.AbstractXsltFileUpgradeOperation;

public class XsltFileUpgradeOperation
extends AbstractXsltFileUpgradeOperation {
    public static final String CONFIG_KEY_PATH = "path";
    public static final String CONFIG_KEY_TARGET = "target";
    protected String path;
    protected String target;

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void doInit(HierarchicalConfiguration<ImmutableNode> config) {
        super.doInit(config);
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            String configPath = config.getString(CONFIG_KEY_PATH);
            this.path = StringUtils.isNotEmpty((CharSequence)configPath) ? configPath : DefaultUpgradeManagerImpl.getCurrentFile();
        }
        this.target = config.getString(CONFIG_KEY_TARGET, null);
    }

    @Override
    public void execute(String site) throws UpgradeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.executeTemplate(site, this.path, os);
        if (os.size() > 0) {
            String targetPath = StringUtils.isNotEmpty((CharSequence)this.target) ? this.target : this.path;
            this.writeToRepo(site, targetPath, new ByteArrayInputStream(os.toByteArray()));
        }
    }
}

