/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.pipeline;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.YamlConfiguration;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.upgrade.UpgradeOperation;
import org.craftercms.studio.api.v2.upgrade.UpgradePipeline;
import org.craftercms.studio.api.v2.upgrade.UpgradePipelineFactory;
import org.craftercms.studio.api.v2.upgrade.VersionProvider;
import org.craftercms.studio.impl.v2.upgrade.pipeline.DefaultUpgradePipelineImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DefaultUpgradePipelineFactoryImpl
implements UpgradePipelineFactory,
ApplicationContextAware {
    protected Resource configurationFile;
    protected ApplicationContext appContext;
    protected String pipelinePrefix;
    protected String pipelineName;
    protected String pipelinePrototype;

    public DefaultUpgradePipelineFactoryImpl() {
    }

    public DefaultUpgradePipelineFactoryImpl(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    @Required
    public void setPipelinePrefix(String pipelinePrefix) {
        this.pipelinePrefix = pipelinePrefix;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    @Required
    public void setConfigurationFile(Resource configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Required
    public void setPipelinePrototype(String pipelinePrototype) {
        this.pipelinePrototype = pipelinePrototype;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    protected HierarchicalConfiguration loadUpgradeConfiguration() throws UpgradeException {
        YamlConfiguration configuration = new YamlConfiguration();
        try (InputStream is = this.configurationFile.getInputStream();){
            configuration.read(is);
        }
        catch (Exception e) {
            throw new UpgradeException("Error reading configuration file", e);
        }
        return configuration;
    }

    protected UpgradePipeline createPipeline(String name, List<UpgradeOperation> operations) {
        DefaultUpgradePipelineImpl pipeline = (DefaultUpgradePipelineImpl)this.appContext.getBean(this.pipelinePrototype, DefaultUpgradePipelineImpl.class);
        pipeline.setName(name);
        pipeline.setOperations(operations);
        return pipeline;
    }

    @Override
    public UpgradePipeline getPipeline(VersionProvider versionProvider) throws UpgradeException {
        String currentVersion = versionProvider.getCurrentVersion();
        if ("SKIP".equals(currentVersion)) {
            return new DefaultUpgradePipelineImpl();
        }
        LinkedList<UpgradeOperation> operations = new LinkedList<UpgradeOperation>();
        HierarchicalConfiguration config = this.loadUpgradeConfiguration();
        List pipeline = config.configurationsAt(this.pipelinePrefix + "." + this.pipelineName);
        String nextVersion = currentVersion;
        for (HierarchicalConfiguration release : pipeline) {
            String sourceVersion = release.getString("currentVersion");
            String targetVersion = release.getString("nextVersion");
            if (!sourceVersion.equals(nextVersion)) continue;
            List operationsConfig = release.configurationsAt("operations");
            for (HierarchicalConfiguration operationConfig : operationsConfig) {
                UpgradeOperation operation = (UpgradeOperation)this.appContext.getBean(operationConfig.getString("type"), UpgradeOperation.class);
                operation.init(sourceVersion, targetVersion, (HierarchicalConfiguration<ImmutableNode>)operationConfig);
                operations.add(operation);
            }
            nextVersion = targetVersion;
        }
        return this.createPipeline(this.pipelineName, operations);
    }
}

