/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.pipeline;

import java.util.List;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.upgrade.UpgradeOperation;
import org.craftercms.studio.api.v2.upgrade.UpgradePipeline;
import org.springframework.util.StopWatch;

public class DefaultUpgradePipelineImpl
implements UpgradePipeline {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradePipelineImpl.class);
    protected String name;
    protected boolean continueOnError = false;
    protected List<UpgradeOperation> operations;

    public void setName(String name) {
        this.name = name;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setOperations(List<UpgradeOperation> operations) {
        this.operations = operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String site) throws UpgradeException {
        if (this.isEmpty()) {
            return;
        }
        StopWatch watch = new StopWatch(this.name + " pipeline");
        logger.info("============================================================", new Object[0]);
        logger.info("Starting execution of upgrade pipeline: {0}", this.name);
        for (UpgradeOperation operation : this.operations) {
            String operationName = operation.getClass().getSimpleName();
            logger.info("------- Starting execution of operation {0} -------", operationName);
            watch.start(operationName);
            try {
                operation.execute(site);
            }
            catch (UpgradeException e) {
                try {
                    if (!this.continueOnError) {
                        throw e;
                    }
                    logger.error("Execution of operation {0} failed", e, operationName);
                }
                catch (Throwable throwable) {
                    watch.stop();
                    logger.info("------- Execution of operation {0} completed -------", operationName);
                    throw throwable;
                }
                watch.stop();
                logger.info("------- Execution of operation {0} completed -------", operationName);
                continue;
            }
            watch.stop();
            logger.info("------- Execution of operation {0} completed -------", operationName);
        }
        logger.info("Execution of pipeline {0} completed", this.name);
        logger.info("============================================================", new Object[0]);
        if (logger.getLevel().equals("debug")) {
            logger.debug("Pipeline Duration:\n" + watch.prettyPrint(), new Object[0]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.operations == null || this.operations.isEmpty();
    }
}

