/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.pipeline;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClusterSandboxRepoSyncTask;
import org.craftercms.studio.impl.v2.upgrade.pipeline.DefaultUpgradePipelineImpl;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.springframework.beans.factory.annotation.Required;

public class SiteRepositoryUpgradePipelineImpl
extends DefaultUpgradePipelineImpl {
    private static final Logger logger = LoggerFactory.getLogger(SiteRepositoryUpgradePipelineImpl.class);
    protected String siteSandboxBranch;
    protected String siteUpgradeBranch;
    protected String commitMessage;
    protected StudioConfiguration studioConfiguration;
    protected ServicesConfig servicesConfig;
    protected SecurityService securityService;
    protected UserServiceInternal userServiceInternal;
    protected SiteService siteService;
    protected TextEncryptor encryptor;
    protected GeneralLockService generalLockService;
    protected StudioClusterSandboxRepoSyncTask clusterSandboxRepoSyncTask;
    protected RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;

    protected void createTemporaryBranch(String site, Git git) throws GitAPIException {
        List branches = git.branchList().call();
        if (branches.stream().anyMatch(b -> b.getName().contains(this.siteUpgradeBranch))) {
            logger.debug("Temporary branch already exists, changes will be discarded", new Object[0]);
            this.deleteTemporaryBranch(git);
        }
        logger.debug("Creating temporary branch {0} for site {1}", this.siteUpgradeBranch, site);
        git.branchCreate().setName(this.siteUpgradeBranch).call();
    }

    protected void checkoutBranch(String branch, Git git) throws GitAPIException {
        logger.debug("Checking out {0} branch", branch);
        git.checkout().setName(branch).call();
    }

    protected void mergeTemporaryBranch(Repository repository, Git git) throws IOException, GitAPIException {
        logger.debug("Merging changes from upgrade branch", new Object[0]);
        git.merge().include(repository.findRef(this.siteUpgradeBranch)).setMessage(this.commitMessage).setCommit(true).call();
    }

    protected void deleteTemporaryBranch(Git git) throws GitAPIException {
        logger.debug("Removing temporary branch", new Object[0]);
        git.branchDelete().setBranchNames(new String[]{this.siteUpgradeBranch}).call();
    }

    @Override
    public void execute(String site) throws UpgradeException {
        block17: {
            String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
            this.generalLockService.lock(gitLockKey);
            try {
                this.clusterSandboxRepoSyncTask.execute(site);
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, GitRepositories.SANDBOX);
                String sandboxBranch = this.siteSandboxBranch;
                if (repository == null) break block17;
                Git git = new Git(repository);
                try {
                    if (!this.isEmpty()) {
                        SiteFeed siteFeed = this.siteService.getSite(site);
                        if (!StringUtils.isEmpty((CharSequence)siteFeed.getSandboxBranch())) {
                            sandboxBranch = siteFeed.getSandboxBranch();
                        }
                        this.createTemporaryBranch(site, git);
                        this.checkoutBranch(this.siteUpgradeBranch, git);
                        super.execute(site);
                        this.checkoutBranch(sandboxBranch, git);
                        this.mergeTemporaryBranch(repository, git);
                        this.deleteTemporaryBranch(git);
                    }
                }
                catch (IOException | SiteNotFoundException | GitAPIException e) {
                    throw new UpgradeException("Error branching or merging upgrade branch for site " + site, (Exception)e);
                }
                finally {
                    if (!this.isEmpty()) {
                        try {
                            this.checkoutBranch(sandboxBranch, git);
                        }
                        catch (GitAPIException e) {
                            logger.error("Error cleaning up repo for site " + site, (Exception)((Object)e), new Object[0]);
                        }
                    }
                    git.close();
                }
            }
            catch (CryptoException e) {
                throw new UpgradeException("Unexpected error upgrading site " + site, (Exception)((Object)e));
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
    }

    @Required
    public void setSiteSandboxBranch(String siteSandboxBranch) {
        this.siteSandboxBranch = siteSandboxBranch;
    }

    @Required
    public void setSiteUpgradeBranch(String siteUpgradeBranch) {
        this.siteUpgradeBranch = siteUpgradeBranch;
    }

    @Required
    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public TextEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioClusterSandboxRepoSyncTask getClusterSandboxRepoSyncTask() {
        return this.clusterSandboxRepoSyncTask;
    }

    public void setClusterSandboxRepoSyncTask(StudioClusterSandboxRepoSyncTask clusterSandboxRepoSyncTask) {
        this.clusterSandboxRepoSyncTask = clusterSandboxRepoSyncTask;
    }

    public RetryingRepositoryOperationFacade getRetryingRepositoryOperationFacade() {
        return this.retryingRepositoryOperationFacade;
    }

    public void setRetryingRepositoryOperationFacade(RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) {
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
    }
}

