/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.providers;

import javax.sql.DataSource;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.exception.UpgradeNotSupportedException;
import org.craftercms.studio.api.v2.upgrade.VersionProvider;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbVersionProvider
implements VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(DbVersionProvider.class);
    public static final String SCHEMA = "{schema}";
    public static final String SQL_QUERY_META = "SELECT count(*) FROM information_schema.tables WHERE table_schema = '{schema}' AND table_name = '_meta' LIMIT 1";
    public static final String SQL_QUERY_VERSION = "select version from _meta";
    public static final String SQL_QUERY_GROUP = "SELECT count(*) FROM information_schema.tables WHERE table_schema = '{schema}' AND table_name = 'cstudio_group' LIMIT 1";
    protected DataSource dataSource;
    protected StudioConfiguration studioConfiguration;

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Override
    public String getCurrentVersion() throws UpgradeException {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        logger.debug("Check if _meta table exists.", new Object[0]);
        int count = (Integer)jdbcTemplate.queryForObject(SQL_QUERY_META.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")), Integer.class);
        if (count != 0) {
            logger.debug("_meta table exists.", new Object[0]);
            logger.debug("Get version from _meta table.", new Object[0]);
            return (String)jdbcTemplate.queryForObject(SQL_QUERY_VERSION, String.class);
        }
        logger.debug("Check if group table exists.", new Object[0]);
        count = (Integer)jdbcTemplate.queryForObject(SQL_QUERY_GROUP.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")), Integer.class);
        if (count != 0) {
            logger.debug("Database version is 3.0.0", new Object[0]);
            return "3.0.0";
        }
        throw new UpgradeNotSupportedException("Automated migration from 2.5.x DB is not supported yet.");
    }
}

