/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.upgrade.providers;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v2.exception.UpgradeException;
import org.craftercms.studio.api.v2.exception.UpgradeNotSupportedException;
import org.craftercms.studio.api.v2.upgrade.VersionProvider;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Document;

public class XmlFileVersionProvider
implements VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(XmlFileVersionProvider.class);
    protected String site;
    protected String path;
    protected String xpath;
    protected String defaultVersion;
    protected boolean skipIfMissing = true;
    protected ContentRepository contentRepository;

    public XmlFileVersionProvider(String site, String path) {
        this.site = site;
        this.path = path;
    }

    @Required
    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Required
    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    @Required
    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public void setSkipIfMissing(boolean skipIfMissing) {
        this.skipIfMissing = skipIfMissing;
    }

    @Override
    public String getCurrentVersion() throws UpgradeException {
        String currentVersion = this.defaultVersion;
        if (!this.contentRepository.contentExists(this.site, "/config/studio")) {
            String firstCommit = this.contentRepository.getRepoFirstCommitId(this.site);
            if (StringUtils.isNotEmpty((CharSequence)firstCommit)) {
                throw new UpgradeNotSupportedException("Site '" + this.site + "' from 2.5.x can't be automatically upgraded");
            }
        } else {
            if (!this.contentRepository.contentExists(this.site, this.path)) {
                logger.debug("Missing file {0} in site {1}", this.path, this.site);
                if (this.skipIfMissing) {
                    return "SKIP";
                }
                return this.defaultVersion;
            }
            try (InputStream is = this.contentRepository.getContent(this.site, this.path);){
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document xmlDocument = builder.parse(is);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String fileVersion = (String)xPath.compile(this.xpath).evaluate(xmlDocument, XPathConstants.STRING);
                if (StringUtils.isNotEmpty((CharSequence)fileVersion)) {
                    currentVersion = fileVersion;
                }
            }
            catch (Exception e) {
                throw new UpgradeException("Error reading version from file " + this.path + " in site " + this.site, e);
            }
        }
        return currentVersion;
    }
}

