/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.utils;

public class RingBuffer<T> {
    protected T[] ringBuffer;
    protected int writeCursor = 0;
    protected int readCursor = 0;
    protected int size;

    public RingBuffer(int size) {
        this.size = size;
        this.ringBuffer = new Object[size];
    }

    public void write(T element) {
        this.ringBuffer[this.writeCursor % this.size] = element;
        ++this.writeCursor;
        if (this.writeCursor > this.size) {
            ++this.readCursor;
        }
    }

    public T read() {
        T element = null;
        if (this.readCursor < this.writeCursor) {
            element = this.ringBuffer[this.readCursor % this.size];
            ++this.readCursor;
        }
        return element;
    }
}

