/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.YamlConfiguration;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;

public class StudioConfigurationImpl
implements StudioConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StudioConfigurationImpl.class);
    protected HierarchicalConfiguration<ImmutableNode> config;
    protected HierarchicalConfiguration<ImmutableNode> systemConfig;
    protected Cache configurationCache;
    protected String configLocation;

    public StudioConfigurationImpl(Cache configurationCache, String configLocation) {
        this.configurationCache = configurationCache;
        this.configLocation = configLocation;
    }

    public void init() {
        this.loadConfig();
    }

    @Override
    public void loadConfig() {
        YamlConfiguration baseConfig = new YamlConfiguration();
        YamlConfiguration overrideConfig = new YamlConfiguration();
        ClassPathResource resource = new ClassPathResource(this.configLocation);
        try (InputStream in = resource.getInputStream();){
            baseConfig.setExpressionEngine(this.getExpressionEngine());
            baseConfig.read(in);
            logger.debug("Loaded configuration from location: {0} \n {1}", this.configLocation, baseConfig);
        }
        catch (IOException | ConfigurationException e) {
            logger.error("Failed to load studio configuration from: " + this.configLocation, (Exception)e, new Object[0]);
        }
        if (baseConfig.containsKey("studio.config.overrideConfig")) {
            String overrideConfigLocation = baseConfig.getString("studio.config.overrideConfig");
            resource = new ClassPathResource(overrideConfigLocation);
            try (InputStream in = resource.getInputStream();){
                overrideConfig.setExpressionEngine(this.getExpressionEngine());
                overrideConfig.read(in);
                if (!overrideConfig.isEmpty()) {
                    logger.debug("Loaded additional configuration from location: {0} \n {1}", overrideConfigLocation, overrideConfig);
                }
            }
            catch (IOException | ConfigurationException e) {
                logger.error("Failed to load studio configuration from: " + overrideConfigLocation, (Exception)e, new Object[0]);
            }
        }
        if (!overrideConfig.isEmpty()) {
            CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
            combinedConfig.setExpressionEngine(this.getExpressionEngine());
            combinedConfig.addConfiguration((Configuration)overrideConfig);
            combinedConfig.addConfiguration((Configuration)baseConfig);
            this.config = combinedConfig;
        } else {
            this.config = baseConfig;
        }
        this.systemConfig = this.config;
        this.config = this.loadGlobalRepoConfig();
    }

    private HierarchicalConfiguration<ImmutableNode> loadGlobalRepoConfig() {
        FileSystemResource fsr;
        String cacheKey = StringUtils.prependIfMissing((String)this.config.getString("studio.config.globalRepoOverrideConfig"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        Path globalRepoOverrideConfigLocation = Paths.get(this.config.getString("studio.repo.basePath"), this.config.getString("studio.repo.globalRepoPath"), this.config.getString("studio.config.globalRepoOverrideConfig"));
        HierarchicalConfiguration globalRepoConfig = null;
        Element element = this.configurationCache.get((Serializable)((Object)cacheKey));
        if (element != null && !element.isExpired()) {
            globalRepoConfig = (HierarchicalConfiguration)element.getObjectValue();
        } else if (this.config.containsKey("studio.config.globalRepoOverrideConfig") && (fsr = new FileSystemResource(globalRepoOverrideConfigLocation.toFile())).exists()) {
            try {
                YamlConfiguration globalRepoOverrideConfig = new YamlConfiguration();
                try (InputStream in = fsr.getInputStream();){
                    globalRepoOverrideConfig.setExpressionEngine(this.getExpressionEngine());
                    globalRepoOverrideConfig.read(in);
                    if (!globalRepoOverrideConfig.isEmpty()) {
                        logger.debug("Loaded additional configuration from location: {0} \n {1}", fsr.getPath(), globalRepoOverrideConfig);
                    }
                    globalRepoConfig = globalRepoOverrideConfig;
                    this.configurationCache.put(new Element((Object)cacheKey, (Object)globalRepoConfig));
                }
            }
            catch (IOException | ConfigurationException e) {
                logger.error("Failed to load studio configuration from: " + fsr.getPath(), (Exception)e, new Object[0]);
                this.configurationCache.put(new Element((Serializable)((Object)cacheKey), null));
            }
        }
        if (globalRepoConfig != null && !globalRepoConfig.isEmpty()) {
            CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
            combinedConfig.setExpressionEngine(this.getExpressionEngine());
            combinedConfig.addConfiguration((Configuration)globalRepoConfig);
            combinedConfig.addConfiguration(this.systemConfig);
            this.config = combinedConfig;
        }
        return this.config;
    }

    protected ExpressionEngine getExpressionEngine() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setPropertyDelimiter("/").setEscapedDelimiter("\\/").create();
        return new DefaultExpressionEngine(symbols);
    }

    protected HierarchicalConfiguration<ImmutableNode> getConfig() {
        return this.loadGlobalRepoConfig();
    }

    @Override
    public String getProperty(String key) {
        return this.getConfig().getString(key);
    }

    @Override
    public <T> T getProperty(String key, Class<T> clazz) {
        return (T)this.getConfig().get(clazz, key);
    }

    @Override
    public <T> T getProperty(String key, Class<T> clazz, T defaultVal) {
        return (T)this.getConfig().get(clazz, key, defaultVal);
    }

    @Override
    public <T> T[] getArray(String key, Class<T> clazz) {
        return (Object[])this.getConfig().getArray(clazz, key);
    }

    @Override
    public HierarchicalConfiguration<ImmutableNode> getSubConfig(String key) {
        try {
            return this.getConfig().configurationAt(key);
        }
        catch (Exception e) {
            logger.debug("Failed to load configuration value for key " + key + ". Returning null.", new Object[0]);
            return null;
        }
    }

    @Override
    public List<HierarchicalConfiguration<ImmutableNode>> getSubConfigs(String key) {
        try {
            return this.config.configurationsAt(key);
        }
        catch (Exception e) {
            logger.error("Failed to load values for " + key, new Object[0]);
            return null;
        }
    }
}

