/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.utils;

import java.util.ArrayList;
import java.util.List;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class StudioUtils {
    private ServicesConfig servicesConfig;
    private ContentService contentService;
    private StudioConfiguration studioConfiguration;

    public List<String> getEnvironmentNames(String siteId) {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(this.servicesConfig.getLiveEnvironment(siteId));
        if (this.servicesConfig.isStagingEnvironmentEnabled(siteId)) {
            toRet.add(this.servicesConfig.getStagingEnvironment(siteId));
        }
        return toRet;
    }

    public ContentItemTO getContentItemForDashboard(String site, String path) {
        ContentItemTO item = null;
        if (!this.contentService.contentExists(site, path)) {
            item = this.contentService.createDummyDmContentItemForDeletedNode(site, path);
            item.setLockOwner("");
        } else {
            item = this.contentService.getContentItem(site, path, 0);
        }
        return item;
    }

    public int getBulkOperationsBatchSize() {
        return Integer.parseInt(this.studioConfiguration.getProperty("studio.db.bulkOperations.batchSize"));
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

