/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.utils.spring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.springframework.core.io.AbstractResource;

public class ContentResource
extends AbstractResource {
    protected ContentService contentService;
    protected String site;
    protected String path;

    public ContentResource(ContentService contentService, String site, String path) {
        this.contentService = contentService;
        this.site = site;
        this.path = path;
    }

    public boolean exists() {
        return this.contentService.contentExists(this.site, this.path);
    }

    public long contentLength() {
        return this.contentService.getContentSize(this.site, this.path);
    }

    public long lastModified() {
        return System.currentTimeMillis();
    }

    public String getFilename() {
        return FilenameUtils.getName((String)this.path);
    }

    public String getDescription() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.contentService.getContent(this.site, this.path);
        }
        catch (CryptoException | ContentNotFoundException e) {
            throw new FileNotFoundException("No content found for '" + this.path + "' in site: " + this.site);
        }
    }
}

