/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.utils.spring;

import com.hazelcast.config.Config;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class HazelcastInstanceFactoryBean
extends AbstractFactoryBean<HazelcastInstance> {
    private Resource configLocation;

    @Required
    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public Class<?> getObjectType() {
        return HazelcastInstance.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HazelcastInstance createInstance() throws Exception {
        try (InputStream is = this.configLocation.getInputStream();){
            HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)new YamlConfigBuilder(is).build());
            return hazelcastInstance;
        }
        catch (IOException e) {
            throw new IOException("Error while loading Hazelcast config at " + this.configLocation.getDescription(), e);
        }
    }

    protected void destroyInstance(HazelcastInstance instance) throws Exception {
        instance.shutdown();
    }
}

