/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.permissions;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.craftercms.commons.security.permissions.Permission;

public class CompositePermission
implements Permission {
    protected Set<Permission> permissions;

    public boolean isAllowed(String action) {
        return this.permissions.stream().allMatch(p -> p.isAllowed(action));
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public CompositePermission addPermission(Permission permission) {
        if (Objects.nonNull(permission)) {
            if (Objects.isNull(this.permissions)) {
                this.permissions = new HashSet<Permission>();
            }
            this.permissions.add(permission);
        }
        return this;
    }

    public CompositePermission addPermission(CompositePermission compositePermission, Permission permission) {
        if (Objects.nonNull(compositePermission)) {
            if (Objects.nonNull(permission)) {
                compositePermission.addPermission(permission);
            }
        } else if (Objects.nonNull(permission)) {
            CompositePermission cp = new CompositePermission();
            return cp.addPermission(permission);
        }
        return compositePermission;
    }

    public String toString() {
        return this.permissions.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositePermission that = (CompositePermission)o;
        return this.permissions.stream().anyMatch(p -> !that.permissions.contains(p));
    }

    public int hashCode() {
        return this.permissions != null ? this.permissions.hashCode() : 0;
    }
}

