/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.commons.security.permissions.PermissionResolver;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.permissions.CompositePermission;
import org.springframework.beans.factory.annotation.Required;

public class CompositePermissionResolverImpl
implements PermissionResolver<String, Map<String, Object>> {
    public static final String SITE_ID_RESOURCE_ID = "siteId";
    public static final String PATH_RESOURCE_ID = "path";
    public static final String PATH_LIST_RESOURCE_ID = "pathList";
    private SecurityService securityService;
    private StudioConfiguration studioConfiguration;

    @Required
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public Permission getGlobalPermission(String username) throws PermissionException {
        return this.getPermission(username, Collections.emptyMap());
    }

    public Permission getPermission(String username, Map<String, Object> resourceIds) throws PermissionException {
        String siteName = "";
        List<String> paths = new ArrayList<String>();
        if (MapUtils.isNotEmpty(resourceIds)) {
            if (resourceIds.containsKey(SITE_ID_RESOURCE_ID) && StringUtils.equals((CharSequence)(siteName = (String)resourceIds.get(SITE_ID_RESOURCE_ID)), (CharSequence)this.studioConfiguration.getProperty("studio.configuration.global.systemSite"))) {
                siteName = "";
            }
            if (resourceIds.containsKey(PATH_RESOURCE_ID)) {
                paths.add((String)resourceIds.get(PATH_RESOURCE_ID));
            }
            if (resourceIds.containsKey(PATH_LIST_RESOURCE_ID)) {
                paths = (List)resourceIds.get(PATH_LIST_RESOURCE_ID);
            }
        }
        if (CollectionUtils.isEmpty(paths)) {
            paths.add("/");
        }
        String finalSiteName = siteName;
        CompositePermission permission = paths.stream().map(x -> {
            DefaultPermission dp = new DefaultPermission();
            Set<String> allowedActions = this.securityService.getUserPermissions(finalSiteName, (String)x, username, null);
            dp.setAllowedActions(allowedActions);
            return dp;
        }).collect(CompositePermission::new, CompositePermission::addPermission, CompositePermission::addPermission);
        return permission;
    }
}

