/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.permissions;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.commons.security.permissions.PermissionResolver;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.factory.annotation.Required;

public class PermissionResolverImpl
implements PermissionResolver<String, Map<String, Object>> {
    public static final String SITE_ID_RESOURCE_ID = "siteId";
    public static final String PATH_RESOURCE_ID = "path";
    private SecurityService securityService;
    private StudioConfiguration studioConfiguration;

    @Required
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public Permission getGlobalPermission(String username) throws PermissionException {
        return this.getPermission(username, Collections.emptyMap());
    }

    public Permission getPermission(String username, Map<String, Object> resourceIds) throws PermissionException {
        String siteName = "";
        String path = "/";
        if (MapUtils.isNotEmpty(resourceIds)) {
            if (resourceIds.containsKey(SITE_ID_RESOURCE_ID) && StringUtils.equals((CharSequence)(siteName = (String)resourceIds.get(SITE_ID_RESOURCE_ID)), (CharSequence)this.studioConfiguration.getProperty("studio.configuration.global.systemSite"))) {
                siteName = "";
            }
            if (resourceIds.containsKey(PATH_RESOURCE_ID)) {
                path = (String)resourceIds.get(PATH_RESOURCE_ID);
            }
        }
        Set<String> allowedActions = this.securityService.getUserPermissions(siteName, path, username, null);
        DefaultPermission permission = new DefaultPermission();
        permission.setAllowedActions(allowedActions);
        return permission;
    }
}

