/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import ch.vorburger.exec.ManagedProcessListener;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.OsUtils;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.SystemUtils;

public class DBConfigurationBuilder {
    protected static final String WIN32 = "win32";
    protected static final String WIN64 = "win64";
    protected static final String LINUX = "linux";
    protected static final String OSX = "osx";
    protected static final String ALPINE = "alpine";
    private static final String DEFAULT_DATA_DIR = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j/data";
    private static final String DEFAULT_TMP_DIR = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j/tmp";
    private String databaseVersion = null;
    protected String osDirectoryName = SystemUtils.IS_OS_WINDOWS ? "win64" : (SystemUtils.IS_OS_MAC ? "osx" : (OsUtils.isAlpine() ? "alpine" : "linux"));
    protected String baseDir = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j/base";
    protected String libDir = null;
    protected String dataDir = DEFAULT_DATA_DIR;
    protected String tmpDir = DEFAULT_TMP_DIR;
    protected String socket = null;
    protected int port = 0;
    protected boolean isDeletingTemporaryBaseAndDataDirsOnShutdown = true;
    protected boolean isUnpackingFromClasspath = true;
    protected List<String> args = new ArrayList<String>();
    private boolean isSecurityDisabled = true;
    private String defaultRootPassword;
    private String driverClassName = "org.mariadb.jdbc.Driver";
    private boolean frozen = false;
    private ManagedProcessListener listener;
    protected String defaultCharacterSet = null;
    protected Map<DBConfiguration.Executable, Supplier<File>> executables = new HashMap<DBConfiguration.Executable, Supplier<File>>();

    public static DBConfigurationBuilder newBuilder() {
        return new DBConfigurationBuilder();
    }

    protected DBConfigurationBuilder() {
    }

    protected void checkIfFrozen(String setterName) {
        if (this.frozen) {
            throw new IllegalStateException("cannot " + setterName + "() anymore after build()");
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public DBConfigurationBuilder setBaseDir(String baseDir) {
        this.checkIfFrozen("setBaseDir");
        this.baseDir = baseDir;
        return this;
    }

    public String getLibDir() {
        if (this.libDir == null) {
            return this.baseDir + "/libs";
        }
        return this.libDir;
    }

    public DBConfigurationBuilder setLibDir(String libDir) {
        this.checkIfFrozen("setLibDir");
        this.libDir = libDir;
        return this;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public DBConfigurationBuilder setDataDir(String dataDir) {
        this.checkIfFrozen("setDataDir");
        this.dataDir = dataDir;
        return this;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public DBConfigurationBuilder setTmpDir(String tmpDir) {
        this.checkIfFrozen("setTmpDir");
        this.tmpDir = tmpDir;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public DBConfigurationBuilder setPort(int port) {
        this.checkIfFrozen("setPort");
        this.port = port;
        return this;
    }

    public DBConfigurationBuilder setProcessListener(ManagedProcessListener listener) {
        this.listener = listener;
        return this;
    }

    public ManagedProcessListener getProcessListener() {
        return this.listener;
    }

    public boolean isDeletingTemporaryBaseAndDataDirsOnShutdown() {
        return this.isDeletingTemporaryBaseAndDataDirsOnShutdown;
    }

    public DBConfigurationBuilder setDeletingTemporaryBaseAndDataDirsOnShutdown(boolean doDelete) {
        this.checkIfFrozen("keepsDataAndBaseDir");
        this.isDeletingTemporaryBaseAndDataDirsOnShutdown = doDelete;
        return this;
    }

    protected int detectFreePort() {
        try {
            ServerSocket ss = new ServerSocket(0);
            this.port = ss.getLocalPort();
            ss.setReuseAddress(true);
            ss.close();
            return this.port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSocket() {
        return this.socket;
    }

    public DBConfigurationBuilder setSocket(String socket) {
        this.checkIfFrozen("setSocket");
        this.socket = socket;
        return this;
    }

    public DBConfiguration build() {
        this.frozen = true;
        return new DBConfiguration.Impl(this._getPort(), this._getSocket(), this._getBinariesClassPathLocation(), this.getBaseDir(), this.getLibDir(), this._getDataDir(), this._getTmpDir(), WIN64.equals(this.getOS()), this._getArgs(), this._getOSLibraryEnvironmentVarName(), this.isSecurityDisabled(), this.isDeletingTemporaryBaseAndDataDirsOnShutdown(), this::getURL, this.getDefaultCharacterSet(), this._getExecutables(), this.getProcessListener(), this.getDefaultRootPassword(), this.getDriverClassName());
    }

    public DBConfigurationBuilder setSecurityDisabled(boolean isSecurityDisabled) {
        this.checkIfFrozen("setSecurityDisabled");
        this.isSecurityDisabled = isSecurityDisabled;
        return this;
    }

    public boolean isSecurityDisabled() {
        return this.isSecurityDisabled;
    }

    public DBConfigurationBuilder addArg(String arg) {
        this.checkIfFrozen("addArg");
        this.args.add(arg);
        return this;
    }

    protected String _getDataDir() {
        if (this.isNull(this.getDataDir()) || this.getDataDir().equals(DEFAULT_DATA_DIR)) {
            return DEFAULT_DATA_DIR + File.separator + this.getPort();
        }
        return this.getDataDir();
    }

    protected String _getTmpDir() {
        if (this.isNull(this.getTmpDir()) || this.getTmpDir().equals(DEFAULT_TMP_DIR)) {
            return DEFAULT_TMP_DIR + File.separator + this.getPort();
        }
        return this.getTmpDir();
    }

    protected boolean isNull(String string) {
        if (string == null) {
            return true;
        }
        String trim = string.trim();
        return trim.length() == 0 || trim.equalsIgnoreCase("null");
    }

    protected int _getPort() {
        int port = this.getPort();
        if (port == 0) {
            port = this.detectFreePort();
        }
        return port;
    }

    protected String _getSocket() {
        Object socket = this.getSocket();
        if (socket == null) {
            String portStr = String.valueOf(this.getPort());
            socket = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j." + portStr + ".sock";
        }
        return socket;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public DBConfigurationBuilder setDatabaseVersion(String databaseVersion) {
        this.checkIfFrozen("setDatabaseVersion");
        this.databaseVersion = databaseVersion;
        return this;
    }

    protected String _getDatabaseVersion() {
        String databaseVersion = this.getDatabaseVersion();
        if (databaseVersion == null) {
            if (OSX.equals(this.getOS())) {
                databaseVersion = "mariadb-10.4.31.2";
            } else if (ALPINE.equals(this.getOS())) {
                databaseVersion = "mariadb-10.4.31.2";
            } else if (LINUX.equals(this.getOS())) {
                databaseVersion = "mariadb-10.4.31.2";
            } else if (WIN64.equals(this.getOS())) {
                databaseVersion = "mariadb-10.4.31.2";
            } else {
                throw new IllegalStateException("OS not directly supported, please use setDatabaseVersion() to set the name of the package that the binaries are in, for: " + SystemUtils.OS_VERSION);
            }
        }
        return databaseVersion;
    }

    protected String getBinariesClassPathLocation() {
        StringBuilder binariesClassPathLocation = new StringBuilder();
        binariesClassPathLocation.append(this.getClass().getPackage().getName().replace(".", "/"));
        binariesClassPathLocation.append("/").append(this._getDatabaseVersion()).append("/");
        binariesClassPathLocation.append(this.getOS());
        return binariesClassPathLocation.toString();
    }

    public DBConfigurationBuilder setOS(String osDirectoryName) {
        this.checkIfFrozen("setOS");
        this.osDirectoryName = osDirectoryName;
        return this;
    }

    public String getOS() {
        return this.osDirectoryName;
    }

    protected String _getOSLibraryEnvironmentVarName() {
        return SystemUtils.IS_OS_WINDOWS ? "PATH" : (SystemUtils.IS_OS_MAC ? "DYLD_FALLBACK_LIBRARY_PATH" : "LD_LIBRARY_PATH");
    }

    protected String _getBinariesClassPathLocation() {
        if (this.isUnpackingFromClasspath) {
            return this.getBinariesClassPathLocation();
        }
        return null;
    }

    public boolean isUnpackingFromClasspath() {
        return this.isUnpackingFromClasspath;
    }

    public DBConfigurationBuilder setUnpackingFromClasspath(boolean isUnpackingFromClasspath) {
        this.checkIfFrozen("setUnpackingFromClasspath");
        this.isUnpackingFromClasspath = isUnpackingFromClasspath;
        return this;
    }

    public String getURL(String databaseName) {
        return "jdbc:mariadb://localhost:" + this.getPort() + "/" + databaseName;
    }

    public List<String> _getArgs() {
        return this.args;
    }

    public String getDefaultRootPassword() {
        return this.defaultRootPassword;
    }

    public DBConfigurationBuilder setDefaultRootPassword(String defaultRootPassword) {
        this.checkIfFrozen("setDefaultRootPasswrd");
        this.defaultRootPassword = defaultRootPassword;
        return this;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public DBConfigurationBuilder setDriverClassName(String driverClassName) {
        this.checkIfFrozen("setDriverClassName");
        this.driverClassName = driverClassName;
        return this;
    }

    public DBConfigurationBuilder setDefaultCharacterSet(String defaultCharacterSet) {
        this.checkIfFrozen("setDefaultCharacterSet");
        this.defaultCharacterSet = defaultCharacterSet;
        return this;
    }

    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public DBConfigurationBuilder setExecutable(DBConfiguration.Executable executable, String path) {
        this.checkIfFrozen("setExecutable");
        this.executables.put(Objects.requireNonNull(executable, "executable"), () -> new File(Objects.requireNonNull(path, "path")));
        return this;
    }

    public DBConfigurationBuilder setExecutable(DBConfiguration.Executable executable, Supplier<File> pathSupplier) {
        this.checkIfFrozen("setExecutable");
        this.executables.put(Objects.requireNonNull(executable, "executable"), Objects.requireNonNull(pathSupplier, "pathSupplier"));
        return this;
    }

    protected Map<DBConfiguration.Executable, Supplier<File>> _getExecutables() {
        this.executables.putIfAbsent(DBConfiguration.Executable.Server, () -> new File(this.baseDir, "bin/mysqld" + this.getExtension()));
        this.executables.putIfAbsent(DBConfiguration.Executable.Client, () -> new File(this.baseDir, "bin/mysql" + this.getExtension()));
        this.executables.putIfAbsent(DBConfiguration.Executable.Dump, () -> new File(this.baseDir, "bin/mysqldump" + this.getExtension()));
        this.executables.putIfAbsent(DBConfiguration.Executable.PrintDefaults, () -> new File(this.baseDir, "bin/my_print_defaults" + this.getExtension()));
        this.executables.putIfAbsent(DBConfiguration.Executable.InstallDB, () -> {
            File bin = new File(this.baseDir, "bin/mysql_install_db" + this.getExtension());
            if (bin.exists()) {
                return bin;
            }
            return new File(this.baseDir, "scripts/mysql_install_db" + this.getExtension());
        });
        return this.executables;
    }

    public boolean isWindows() {
        return WIN32.equals(this.getOS());
    }

    protected String getExtension() {
        return this.isWindows() ? ".exe" : "";
    }
}

