/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import ch.vorburger.exec.ManagedProcess;
import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DBShutdownHook
extends Thread
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(DB.class);
    private final DB db;
    private final Supplier<ManagedProcess> mysqldProcessSupplier;
    private final Supplier<File> dataDirSupplier;
    private final Supplier<File> baseDirSupplier;
    private final Supplier<File> tmpDirSupplier;
    private final DBConfiguration configuration;
    private final LinkOption[] linkOptions = new LinkOption[0];

    public DBShutdownHook(String threadName, DB db, Supplier<ManagedProcess> mysqldProcessSupplier, Supplier<File> baseDirSupplier, Supplier<File> tmpDirSupplier, Supplier<File> dataDirSupplier, DBConfiguration configuration) {
        super(threadName);
        this.db = db;
        this.mysqldProcessSupplier = mysqldProcessSupplier;
        this.baseDirSupplier = baseDirSupplier;
        this.dataDirSupplier = dataDirSupplier;
        this.tmpDirSupplier = tmpDirSupplier;
        this.configuration = configuration;
    }

    private boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                this.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private void cleanDirectory(File directory) throws IOException {
        File[] files = this.listFiles(directory, null);
        ArrayList<IOException> causeList = new ArrayList<IOException>();
        for (File file : files) {
            try {
                this.forceDelete(file);
            }
            catch (IOException exception) {
                causeList.add(exception);
            }
        }
        if (!causeList.isEmpty()) {
            IOException ioException = new IOException(directory.toString());
            causeList.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }

    private void forceDelete(File file) throws IOException {
        Objects.requireNonNull(file, "file");
        try {
            this.delete(file.toPath());
        }
        catch (IOException exception) {
            throw new IOException("Cannot delete file: " + file, exception);
        }
    }

    private void delete(Path path) throws IOException {
        if (Files.isDirectory(path, this.linkOptions)) {
            this.deleteDirectory(path);
        } else {
            this.deleteFile(path);
        }
    }

    private void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, this);
    }

    private void deleteFile(Path file) throws IOException {
        if (Files.isDirectory(file, this.linkOptions)) {
            throw new NoSuchFileException(file.toString());
        }
        boolean exists = Files.exists(file, this.linkOptions);
        if (exists) {
            this.setReadOnly(file, false);
        }
        Files.deleteIfExists(file);
    }

    private Path setReadOnly(Path path, boolean readOnly) throws IOException {
        PosixFileAttributeView posixFileAttributeView;
        ArrayList<IOException> causeList = new ArrayList<IOException>(2);
        DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, this.linkOptions);
        if (fileAttributeView != null) {
            try {
                fileAttributeView.setReadOnly(readOnly);
                return path;
            }
            catch (IOException exception) {
                causeList.add(exception);
            }
        }
        if ((posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, this.linkOptions)) != null) {
            PosixFileAttributes readAttributes = posixFileAttributeView.readAttributes();
            Set<PosixFilePermission> permissions = readAttributes.permissions();
            permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
            try {
                return Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException exception) {
                causeList.add(exception);
            }
        }
        if (!causeList.isEmpty()) {
            IOException ioException = new IOException(path.toString());
            causeList.forEach(ioException::addSuppressed);
            throw ioException;
        }
        throw new IOException(String.format("No DosFileAttributeView or PosixFileAttributeView for '%s' (linkOptions=%s)", path, Arrays.toString(this.linkOptions)));
    }

    private File[] listFiles(File directory, FileFilter fileFilter) throws IOException {
        File[] files;
        this.requireDirectoryExists(directory, "directory");
        File[] fileArray = files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);
        if (files == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + directory);
        }
        return files;
    }

    private File requireDirectoryExists(File directory, String name) {
        this.requireExists(directory, name);
        this.requireDirectory(directory, name);
        return directory;
    }

    private File requireExists(File file, String fileParamName) {
        Objects.requireNonNull(file, fileParamName);
        if (!file.exists()) {
            throw new IllegalArgumentException("File system element for parameter '" + fileParamName + "' does not exist: '" + file + "'");
        }
        return file;
    }

    private File requireDirectory(File directory, String name) {
        Objects.requireNonNull(directory, name);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Parameter '" + name + "' is not a directory: '" + directory + "'");
        }
        return directory;
    }

    private boolean isEmptyDirectory(Path directory) throws IOException {
        boolean hasNext;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            hasNext = !directoryStream.iterator().hasNext();
        }
        return hasNext;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (Files.exists(file, this.linkOptions)) {
            this.setReadOnly(file, false);
            Files.deleteIfExists(file);
        }
        if (Files.isSymbolicLink(file)) {
            try {
                Files.delete(file);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        Objects.requireNonNull(file);
        throw exc;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (this.isEmptyDirectory(dir)) {
            Files.deleteIfExists(dir);
        }
        Objects.requireNonNull(dir);
        if (exc != null) {
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public void run() {
        File tmpDir;
        File baseDir;
        ManagedProcess mysqldProcess = this.mysqldProcessSupplier.get();
        try {
            if (mysqldProcess != null && mysqldProcess.isAlive()) {
                logger.info("cleanupOnExit() ShutdownHook now stopping database");
                this.db.stop();
            }
        }
        catch (ManagedProcessException e) {
            logger.warn("cleanupOnExit() ShutdownHook: An error occurred while stopping the database", (Throwable)e);
        }
        File dataDir = this.dataDirSupplier.get();
        if (dataDir.exists() && this.configuration.isDeletingTemporaryBaseAndDataDirsOnShutdown() && Util.isTemporaryDirectory(dataDir.getAbsolutePath())) {
            logger.info("cleanupOnExit() ShutdownHook quietly deleting temporary DB data directory: " + dataDir);
            this.deleteQuietly(dataDir);
        }
        if ((baseDir = this.baseDirSupplier.get()).exists() && this.configuration.isDeletingTemporaryBaseAndDataDirsOnShutdown() && Util.isTemporaryDirectory(baseDir.getAbsolutePath())) {
            logger.info("cleanupOnExit() ShutdownHook quietly deleting temporary DB base directory: " + baseDir);
            this.deleteQuietly(baseDir);
        }
        if ((tmpDir = this.tmpDirSupplier.get()).exists() && Util.isTemporaryDirectory(tmpDir.getAbsolutePath())) {
            logger.info("cleanupOnExit() ShutdownHook quietly deleting temporary DB tmp directory: " + tmpDir);
            this.deleteQuietly(tmpDir);
        }
    }
}

