/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import ch.vorburger.mariadb4j.ManagedProcessRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class MariaDB4jService {
    protected DB db;
    protected DBConfigurationBuilder configBuilder;

    public DB getDB() {
        if (!this.isRunning()) {
            throw new IllegalStateException("start() me up first!");
        }
        return this.db;
    }

    public DBConfigurationBuilder getConfiguration() {
        if (this.configBuilder == null) {
            this.configBuilder = DBConfigurationBuilder.newBuilder();
        }
        return this.configBuilder;
    }

    @PostConstruct
    public void postConstruct() throws ManagedProcessRuntimeException {
        try {
            this.start();
        }
        catch (ManagedProcessException e) {
            throw new ManagedProcessRuntimeException(e);
        }
    }

    public void start() throws ManagedProcessException {
        if (this.isRunning()) {
            return;
        }
        this.db = DB.newEmbeddedDB(this.getConfiguration().build());
        this.db.start();
    }

    @PreDestroy
    public void preDestroy() throws ManagedProcessRuntimeException {
        try {
            this.stop();
        }
        catch (ManagedProcessException e) {
            throw new ManagedProcessRuntimeException(e);
        }
    }

    public void stop() throws ManagedProcessException {
        if (!this.isRunning()) {
            return;
        }
        this.db.stop();
        this.db = null;
        this.configBuilder = null;
    }

    public boolean isRunning() {
        return this.db != null;
    }

    public static void main(String[] args) throws Exception {
        MariaDB4jService service = new MariaDB4jService();
        service.start();
        MariaDB4jService.waitForKeyPressToCleanlyExit();
        service.stop();
    }

    public static void waitForKeyPressToCleanlyExit() throws IOException {
        System.out.println("\n\nHit Enter to quit...");
        BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
        d.readLine();
    }
}

