/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static File getDirectory(String path) {
        String absPath;
        boolean log = false;
        File dir = new File(path);
        if (!dir.exists()) {
            log = true;
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to create new directory at path: " + path, e);
            }
        }
        if ((absPath = dir.getAbsolutePath()).trim().length() == 0) {
            throw new IllegalArgumentException(path + " is empty");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException(path + " is not a readable directory");
        }
        if (log) {
            logger.info("Created directory: " + absPath);
        }
        return dir;
    }

    public static boolean isTemporaryDirectory(String directory) {
        return directory.startsWith(SystemUtils.JAVA_IO_TMPDIR);
    }

    public static void forceExecutable(File executableFile) throws IOException {
        if (executableFile.exists()) {
            if (!executableFile.canExecute()) {
                boolean succeeded = executableFile.setExecutable(true);
                if (!succeeded) {
                    throw new IOException("Failed to do chmod +x " + executableFile.toString() + " using java.io.File.setExecutable, which will be a problem on *NIX...");
                }
                logger.info("chmod +x {} (using java.io.File.setExecutable)", (Object)executableFile);
            }
        } else {
            logger.info("chmod +x requested on non-existing file: {}", (Object)executableFile);
        }
    }

    public static int extractFromClasspathToFile(String packagePath, File toDir) throws IOException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        String locationPattern = "classpath*:" + packagePath + "/**";
        Resource[] resources = resourcePatternResolver.getResources(locationPattern);
        if (resources.length == 0) {
            throw new IOException("Nothing found at " + locationPattern);
        }
        int counter = 0;
        for (Resource resource : resources) {
            URL url;
            String path;
            if (!resource.isReadable() || (path = (url = resource.getURL()).toString()).endsWith("/")) continue;
            int p = path.lastIndexOf(packagePath) + packagePath.length();
            path = path.substring(p);
            File targetFile = new File(toDir, path);
            long len = resource.contentLength();
            if (targetFile.exists() && targetFile.length() == len) continue;
            Util.tryN(5, 500L, () -> FileUtils.copyURLToFile((URL)url, (File)targetFile));
            ++counter;
        }
        if (counter > 0) {
            Object[] info = new Object[]{counter, locationPattern, toDir};
            logger.info("Unpacked {} files from {} to {}", info);
        }
        return counter;
    }

    private static void tryN(int n, long msToWait, Procedure<IOException> procedure) throws IOException {
        IOException lastIOException = null;
        int numAttempts = 0;
        while (numAttempts++ < n) {
            try {
                procedure.apply();
                return;
            }
            catch (IOException e) {
                lastIOException = e;
                logger.warn("Failure {} of {}, retrying again in {}ms", new Object[]{numAttempts, n, msToWait, e});
                try {
                    Thread.sleep(msToWait);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw lastIOException;
    }

    private static interface Procedure<E extends Throwable> {
        public void apply() throws E;
    }
}

