/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j.junit;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public class MariaDB4jRule
extends ExternalResource {
    private DB db;
    private final String dbName;
    private final String resource;
    private final DBConfiguration dbConfiguration;

    public MariaDB4jRule(DBConfiguration dbConfiguration, String dbName, String resource) {
        this.dbConfiguration = dbConfiguration;
        this.dbName = dbName;
        this.resource = resource;
    }

    public MariaDB4jRule(int port) {
        this(DBConfigurationBuilder.newBuilder().setPort(port).setSecurityDisabled(false).setDefaultRootPassword("root").build(), "", null);
    }

    protected void before() throws Throwable {
        this.db = DB.newEmbeddedDB(this.dbConfiguration);
        this.db.start();
        this.initDB();
    }

    protected void initDB() throws ManagedProcessException {
        if (!StringUtils.isEmpty((CharSequence)this.dbName)) {
            this.db.createDB(this.dbName, "root", "root");
            if (!StringUtils.isEmpty((CharSequence)this.resource)) {
                this.db.source(this.resource, "root", "root", this.dbName);
            }
        }
    }

    protected void after() {
        try {
            this.db.stop();
        }
        catch (ManagedProcessException e) {
            throw new AssertionError("db.stop() failed", e);
        }
    }

    public String getURL() {
        return this.dbConfiguration.getURL(this.dbName);
    }

    public DBConfiguration getDBConfiguration() {
        return this.db.getConfiguration();
    }
}

