/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j.springframework;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.MariaDB4jService;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.Lifecycle;

public class MariaDB4jSpringService
extends MariaDB4jService
implements Lifecycle {
    public static final String PORT = "mariaDB4j.port";
    public static final String SOCKET = "mariaDB4j.socket";
    public static final String DATA_DIR = "mariaDB4j.dataDir";
    public static final String TMP_DIR = "mariaDB4j.tmpDir";
    public static final String BASE_DIR = "mariaDB4j.baseDir";
    public static final String LIB_DIR = "mariaDB4j.libDir";
    public static final String UNPACK = "mariaDB4j.unpack";
    public static final String ARGS = "mariaDB4j.args";
    public static final String OS_USER = "mariaDB4j.osUser";
    public static final String SECURITY_DISABLED = "mariaDB4j.securityDisabled";
    public static final String DEFAULT_ROOT_PASSWORD = "mariaDB4j.defaultRootPassword";
    public static final String DRIVER_CLASS_NAME = "mariaDB4j.driverClassName";
    protected ManagedProcessException lastException;

    @Value(value="${$DBVersion:mariadb-10.4.31.2}")
    public void setDBVersion(String version) {
        this.getConfiguration().setDatabaseVersion(version);
    }

    @Value(value="${mariaDB4j.port:-1}")
    public void setDefaultPort(int port) {
        if (port != -1) {
            this.getConfiguration().setPort(port);
        }
    }

    @Value(value="${mariaDB4j.socket:NA}")
    public void setDefaultSocket(String socket) {
        if (!"NA".equals(socket)) {
            this.getConfiguration().setSocket(socket);
        }
    }

    @Value(value="${mariaDB4j.dataDir:NA}")
    public void setDefaultDataDir(String dataDir) {
        if (!"NA".equals(dataDir)) {
            this.getConfiguration().setDataDir(dataDir);
        }
    }

    @Value(value="${mariaDB4j.tmpDir:NA}")
    public void setDefaultTmpDir(String tmpDir) {
        if (!"NA".equals(tmpDir)) {
            this.getConfiguration().setTmpDir(tmpDir);
        }
    }

    @Value(value="${mariaDB4j.baseDir:NA}")
    public void setDefaultBaseDir(String baseDir) {
        if (!"NA".equals(baseDir)) {
            this.getConfiguration().setBaseDir(baseDir);
        }
    }

    @Value(value="${mariaDB4j.libDir:NA}")
    public void setDefaultLibDir(String libDir) {
        if (!"NA".equals(libDir)) {
            this.getConfiguration().setLibDir(libDir);
        }
    }

    @Value(value="${mariaDB4j.unpack:#{null}}")
    public void setDefaultIsUnpackingFromClasspath(Boolean unpack) {
        if (unpack != null) {
            this.getConfiguration().setUnpackingFromClasspath(unpack);
        }
    }

    @Value(value="${mariaDB4j.args:#{null}}")
    public void setArgs(List<String> args) {
        if (args != null && args.size() > 0) {
            for (String arg : args) {
                this.getConfiguration().addArg(arg);
            }
        }
    }

    @Value(value="${mariaDB4j.osUser:NA}")
    public void setDefaultOsUser(String osUser) {
        if (!"NA".equals(osUser)) {
            this.getConfiguration().addArg("--user=" + osUser);
        }
    }

    @Value(value="${mariaDB4j.securityDisabled:#{null}}")
    public void setSecurityDisabled(Boolean securityDisabled) {
        if (securityDisabled != null) {
            this.getConfiguration().setSecurityDisabled(securityDisabled);
        }
    }

    @Value(value="${mariaDB4j.defaultRootPassword:#NA}")
    public void setDefaultRootPassword(String defaultRootPassword) {
        if (!"NA".equals(defaultRootPassword)) {
            this.getConfiguration().setDefaultRootPassword(defaultRootPassword);
        }
    }

    @Value(value="${mariaDB4j.driverClassName:#NA}")
    public void setDriverClassName(String driverClassName) {
        if (!"NA".equals(driverClassName)) {
            this.getConfiguration().setDriverClassName(driverClassName);
        }
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (ManagedProcessException e) {
            this.lastException = e;
            throw new IllegalStateException("MariaDB4jSpringService start() failed", e);
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        catch (ManagedProcessException e) {
            this.lastException = e;
            throw new IllegalStateException("MariaDB4jSpringService stop() failed", e);
        }
    }

    public ManagedProcessException getLastException() {
        return this.lastException;
    }
}

